/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectConnectGatewayAttachmentsResponse extends DirectConnectResponse
        implements
        ToCopyableBuilder<DescribeDirectConnectGatewayAttachmentsResponse.Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
    private static final SdkField<List<DirectConnectGatewayAttachment>> DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD = SdkField
            .<List<DirectConnectGatewayAttachment>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDirectConnectGatewayAttachmentsResponse::directConnectGatewayAttachments))
            .setter(setter(Builder::directConnectGatewayAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAttachments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectConnectGatewayAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectConnectGatewayAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDirectConnectGatewayAttachmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments;

    private final String nextToken;

    private DescribeDirectConnectGatewayAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAttachments = builder.directConnectGatewayAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DirectConnectGatewayAttachments property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasDirectConnectGatewayAttachments() {
        return directConnectGatewayAttachments != null && !(directConnectGatewayAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDirectConnectGatewayAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attachments.
     */
    public List<DirectConnectGatewayAttachment> directConnectGatewayAttachments() {
        return directConnectGatewayAttachments;
    }

    /**
     * <p>
     * The token to retrieve the next page.
     * </p>
     * 
     * @return The token to retrieve the next page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAttachmentsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAttachmentsResponse other = (DescribeDirectConnectGatewayAttachmentsResponse) obj;
        return Objects.equals(directConnectGatewayAttachments(), other.directConnectGatewayAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDirectConnectGatewayAttachmentsResponse")
                .add("DirectConnectGatewayAttachments", directConnectGatewayAttachments()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAttachments":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAttachments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param directConnectGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param directConnectGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment... directConnectGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DirectConnectGatewayAttachment>.Builder}
         * avoiding the need to create one manually via {@link List<DirectConnectGatewayAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DirectConnectGatewayAttachment>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #directConnectGatewayAttachments(List<DirectConnectGatewayAttachment>)}.
         * 
         * @param directConnectGatewayAttachments
         *        a consumer that will call methods on {@link List<DirectConnectGatewayAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAttachments(List<DirectConnectGatewayAttachment>)
         */
        Builder directConnectGatewayAttachments(
                Consumer<DirectConnectGatewayAttachment.Builder>... directConnectGatewayAttachments);

        /**
         * <p>
         * The token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<DirectConnectGatewayAttachment> directConnectGatewayAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAttachmentsResponse model) {
            super(model);
            directConnectGatewayAttachments(model.directConnectGatewayAttachments);
            nextToken(model.nextToken);
        }

        public final Collection<DirectConnectGatewayAttachment.Builder> getDirectConnectGatewayAttachments() {
            return directConnectGatewayAttachments != null ? directConnectGatewayAttachments.stream()
                    .map(DirectConnectGatewayAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directConnectGatewayAttachments(
                Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copy(directConnectGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment... directConnectGatewayAttachments) {
            directConnectGatewayAttachments(Arrays.asList(directConnectGatewayAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(
                Consumer<DirectConnectGatewayAttachment.Builder>... directConnectGatewayAttachments) {
            directConnectGatewayAttachments(Stream.of(directConnectGatewayAttachments)
                    .map(c -> DirectConnectGatewayAttachment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectConnectGatewayAttachments(
                Collection<DirectConnectGatewayAttachment.BuilderImpl> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier
                    .copyFromBuilder(directConnectGatewayAttachments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectConnectGatewayAttachmentsResponse build() {
            return new DescribeDirectConnectGatewayAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
