/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmConnectionResponse extends DirectConnectResponse implements
        ToCopyableBuilder<ConfirmConnectionResponse.Builder, ConfirmConnectionResponse> {
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfirmConnectionResponse::connectionStateAsString)).setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STATE_FIELD));

    private final String connectionState;

    private ConfirmConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionState = builder.connectionState;
    }

    /**
     * <p>
     * The state of the connection. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection
     * stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state
     * until the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The connection has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up and the connection is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The connection is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The connection has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code>
     * state if it is deleted by the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the connection is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
     *         connection stays in the ordering state until the owner of the hosted connection confirms or declines the
     *         connection order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The connection has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up and the connection is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The connection is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The connection has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
     *         <code>rejected</code> state if it is deleted by the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the connection is not available.
     *         </p>
     *         </li>
     * @see ConnectionState
     */
    public ConnectionState connectionState() {
        return ConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * The state of the connection. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection
     * stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state
     * until the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The connection has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up and the connection is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The connection is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The connection has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code>
     * state if it is deleted by the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the connection is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
     *         connection stays in the ordering state until the owner of the hosted connection confirms or declines the
     *         connection order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The connection has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up and the connection is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The connection is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The connection has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
     *         <code>rejected</code> state if it is deleted by the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the connection is not available.
     *         </p>
     *         </li>
     * @see ConnectionState
     */
    public String connectionStateAsString() {
        return connectionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmConnectionResponse)) {
            return false;
        }
        ConfirmConnectionResponse other = (ConfirmConnectionResponse) obj;
        return Objects.equals(connectionStateAsString(), other.connectionStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfirmConnectionResponse").add("ConnectionState", connectionStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmConnectionResponse, T> g) {
        return obj -> g.apply((ConfirmConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ConfirmConnectionResponse> {
        /**
         * <p>
         * The state of the connection. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         * connection stays in the ordering state until the owner of the hosted connection confirms or declines the
         * connection order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
         * state until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The connection has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up and the connection is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The connection is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The connection has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         * <code>rejected</code> state if it is deleted by the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the connection is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionState
         *        The state of the connection. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         *        connection stays in the ordering state until the owner of the hosted connection confirms or declines
         *        the connection order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a standard connection. The connection stays in the
         *        requested state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The connection has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up and the connection is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The connection is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The connection has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         *        <code>rejected</code> state if it is deleted by the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the connection is not available.
         *        </p>
         *        </li>
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * The state of the connection. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         * connection stays in the ordering state until the owner of the hosted connection confirms or declines the
         * connection order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
         * state until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The connection has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up and the connection is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The connection is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The connection has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         * <code>rejected</code> state if it is deleted by the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the connection is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionState
         *        The state of the connection. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         *        connection stays in the ordering state until the owner of the hosted connection confirms or declines
         *        the connection order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a standard connection. The connection stays in the
         *        requested state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The connection has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up and the connection is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The connection is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The connection has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         *        <code>rejected</code> state if it is deleted by the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the connection is not available.
         *        </p>
         *        </li>
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(ConnectionState connectionState);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String connectionState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmConnectionResponse model) {
            super(model);
            connectionState(model.connectionState);
        }

        public final String getConnectionStateAsString() {
            return connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public ConfirmConnectionResponse build() {
            return new ConfirmConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
