/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDirectConnectGatewayAssociationRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DeleteDirectConnectGatewayAssociationRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteDirectConnectGatewayAssociationRequest.getter(DeleteDirectConnectGatewayAssociationRequest::directConnectGatewayId)).setter(DeleteDirectConnectGatewayAssociationRequest.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteDirectConnectGatewayAssociationRequest.getter(DeleteDirectConnectGatewayAssociationRequest::virtualGatewayId)).setter(DeleteDirectConnectGatewayAssociationRequest.setter(Builder::virtualGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, VIRTUAL_GATEWAY_ID_FIELD));
    private final String directConnectGatewayId;
    private final String virtualGatewayId;

    private DeleteDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualGatewayId = builder.virtualGatewayId;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        DeleteDirectConnectGatewayAssociationRequest other = (DeleteDirectConnectGatewayAssociationRequest)((Object)obj);
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteDirectConnectGatewayAssociationRequest").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualGatewayId": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDirectConnectGatewayAssociationRequest, T> g) {
        return obj -> g.apply((DeleteDirectConnectGatewayAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDirectConnectGatewayAssociationRequest model) {
            super(model);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualGatewayId(model.virtualGatewayId);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDirectConnectGatewayAssociationRequest build() {
            return new DeleteDirectConnectGatewayAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDirectConnectGatewayAssociationRequest> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

