/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVirtualInterfacesRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeVirtualInterfacesRequest> {
    private final String connectionId;
    private final String virtualInterfaceId;

    private DescribeVirtualInterfacesRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualInterfacesRequest)) {
            return false;
        }
        DescribeVirtualInterfacesRequest other = (DescribeVirtualInterfacesRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVirtualInterfacesRequest").add("ConnectionId", (Object)this.connectionId()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String virtualInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualInterfacesRequest model) {
            this.connectionId(model.connectionId);
            this.virtualInterfaceId(model.virtualInterfaceId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVirtualInterfacesRequest build() {
            return new DescribeVirtualInterfacesRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeVirtualInterfacesRequest> {
        public Builder connectionId(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

