/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.VirtualGateway;
import software.amazon.awssdk.services.directconnect.model.VirtualGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVirtualGatewaysResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
    private final List<VirtualGateway> virtualGateways;

    private DescribeVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.virtualGateways = builder.virtualGateways;
    }

    public List<VirtualGateway> virtualGateways() {
        return this.virtualGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGateways());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualGatewaysResponse)) {
            return false;
        }
        DescribeVirtualGatewaysResponse other = (DescribeVirtualGatewaysResponse)((Object)obj);
        return Objects.equals(this.virtualGateways(), other.virtualGateways());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVirtualGatewaysResponse").add("VirtualGateways", this.virtualGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualGateways": {
                return Optional.of(clazz.cast(this.virtualGateways()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<VirtualGateway> virtualGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualGatewaysResponse model) {
            this.virtualGateways(model.virtualGateways);
        }

        public final Collection<VirtualGateway.Builder> getVirtualGateways() {
            return this.virtualGateways != null ? (Collection)this.virtualGateways.stream().map(VirtualGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGateway> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGateway ... virtualGateways) {
            this.virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        public final void setVirtualGateways(Collection<VirtualGateway.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public DescribeVirtualGatewaysResponse build() {
            return new DescribeVirtualGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
        public Builder virtualGateways(Collection<VirtualGateway> var1);

        public Builder virtualGateways(VirtualGateway ... var1);
    }
}

