/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoaRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeLoaRequest> {
    private final String connectionId;
    private final String providerName;
    private final String loaContentType;

    private DescribeLoaRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String providerName() {
        return this.providerName;
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeString() {
        return this.loaContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaRequest)) {
            return false;
        }
        DescribeLoaRequest other = (DescribeLoaRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.loaContentTypeString(), other.loaContentTypeString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoaRequest").add("ConnectionId", (Object)this.connectionId()).add("ProviderName", (Object)this.providerName()).add("LoaContentType", (Object)this.loaContentTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "providerName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
            case "loaContentType": {
                return Optional.of(clazz.cast(this.loaContentTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaRequest model) {
            this.connectionId(model.connectionId);
            this.providerName(model.providerName);
            this.loaContentType(model.loaContentType);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoaRequest build() {
            return new DescribeLoaRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeLoaRequest> {
        public Builder connectionId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

