/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDirectConnectGatewayAttachmentsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
    private final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments;
    private final String nextToken;

    private DescribeDirectConnectGatewayAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAttachments = builder.directConnectGatewayAttachments;
        this.nextToken = builder.nextToken;
    }

    public List<DirectConnectGatewayAttachment> directConnectGatewayAttachments() {
        return this.directConnectGatewayAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAttachmentsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAttachmentsResponse other = (DescribeDirectConnectGatewayAttachmentsResponse)((Object)obj);
        return Objects.equals(this.directConnectGatewayAttachments(), other.directConnectGatewayAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewayAttachmentsResponse").add("DirectConnectGatewayAttachments", this.directConnectGatewayAttachments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayAttachments": {
                return Optional.of(clazz.cast(this.directConnectGatewayAttachments()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGatewayAttachment> directConnectGatewayAttachments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAttachmentsResponse model) {
            this.directConnectGatewayAttachments(model.directConnectGatewayAttachments);
            this.nextToken(model.nextToken);
        }

        public final Collection<DirectConnectGatewayAttachment.Builder> getDirectConnectGatewayAttachments() {
            return this.directConnectGatewayAttachments != null ? (Collection)this.directConnectGatewayAttachments.stream().map(DirectConnectGatewayAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copy(directConnectGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment ... directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments(Arrays.asList(directConnectGatewayAttachments));
            return this;
        }

        public final void setDirectConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment.BuilderImpl> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copyFromBuilder(directConnectGatewayAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectConnectGatewayAttachmentsResponse build() {
            return new DescribeDirectConnectGatewayAttachmentsResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
        public Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> var1);

        public Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment ... var1);

        public Builder nextToken(String var1);
    }
}

