/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeer;
import software.amazon.awssdk.services.directconnect.model.BGPPeerListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.services.directconnect.model.VirtualInterfaceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocatePublicVirtualInterfaceResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, AllocatePublicVirtualInterfaceResponse> {
    private final String ownerAccount;
    private final String virtualInterfaceId;
    private final String location;
    private final String connectionId;
    private final String virtualInterfaceType;
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final Long amazonSideAsn;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final String virtualInterfaceState;
    private final String customerRouterConfig;
    private final String virtualGatewayId;
    private final String directConnectGatewayId;
    private final List<RouteFilterPrefix> routeFilterPrefixes;
    private final List<BGPPeer> bgpPeers;

    private AllocatePublicVirtualInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.location = builder.location;
        this.connectionId = builder.connectionId;
        this.virtualInterfaceType = builder.virtualInterfaceType;
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.virtualInterfaceState = builder.virtualInterfaceState;
        this.customerRouterConfig = builder.customerRouterConfig;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.bgpPeers = builder.bgpPeers;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public String location() {
        return this.location;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String virtualInterfaceType() {
        return this.virtualInterfaceType;
    }

    public String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Integer asn() {
        return this.asn;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyString() {
        return this.addressFamily;
    }

    public VirtualInterfaceState virtualInterfaceState() {
        return VirtualInterfaceState.fromValue(this.virtualInterfaceState);
    }

    public String virtualInterfaceStateString() {
        return this.virtualInterfaceState;
    }

    public String customerRouterConfig() {
        return this.customerRouterConfig;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public List<RouteFilterPrefix> routeFilterPrefixes() {
        return this.routeFilterPrefixes;
    }

    public List<BGPPeer> bgpPeers() {
        return this.bgpPeers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerRouterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeFilterPrefixes());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpPeers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePublicVirtualInterfaceResponse)) {
            return false;
        }
        AllocatePublicVirtualInterfaceResponse other = (AllocatePublicVirtualInterfaceResponse)((Object)obj);
        return Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.virtualInterfaceType(), other.virtualInterfaceType()) && Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.addressFamilyString(), other.addressFamilyString()) && Objects.equals(this.virtualInterfaceStateString(), other.virtualInterfaceStateString()) && Objects.equals(this.customerRouterConfig(), other.customerRouterConfig()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId()) && Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.routeFilterPrefixes(), other.routeFilterPrefixes()) && Objects.equals(this.bgpPeers(), other.bgpPeers());
    }

    public String toString() {
        return ToString.builder((String)"AllocatePublicVirtualInterfaceResponse").add("OwnerAccount", (Object)this.ownerAccount()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Location", (Object)this.location()).add("ConnectionId", (Object)this.connectionId()).add("VirtualInterfaceType", (Object)this.virtualInterfaceType()).add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).add("Vlan", (Object)this.vlan()).add("Asn", (Object)this.asn()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("AuthKey", (Object)this.authKey()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).add("AddressFamily", (Object)this.addressFamilyString()).add("VirtualInterfaceState", (Object)this.virtualInterfaceStateString()).add("CustomerRouterConfig", (Object)this.customerRouterConfig()).add("VirtualGatewayId", (Object)this.virtualGatewayId()).add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("RouteFilterPrefixes", this.routeFilterPrefixes()).add("BgpPeers", this.bgpPeers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "virtualInterfaceType": {
                return Optional.of(clazz.cast(this.virtualInterfaceType()));
            }
            case "virtualInterfaceName": {
                return Optional.of(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.of(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.of(clazz.cast(this.asn()));
            }
            case "amazonSideAsn": {
                return Optional.of(clazz.cast(this.amazonSideAsn()));
            }
            case "authKey": {
                return Optional.of(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.of(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.of(clazz.cast(this.customerAddress()));
            }
            case "addressFamily": {
                return Optional.of(clazz.cast(this.addressFamilyString()));
            }
            case "virtualInterfaceState": {
                return Optional.of(clazz.cast(this.virtualInterfaceStateString()));
            }
            case "customerRouterConfig": {
                return Optional.of(clazz.cast(this.customerRouterConfig()));
            }
            case "virtualGatewayId": {
                return Optional.of(clazz.cast(this.virtualGatewayId()));
            }
            case "directConnectGatewayId": {
                return Optional.of(clazz.cast(this.directConnectGatewayId()));
            }
            case "routeFilterPrefixes": {
                return Optional.of(clazz.cast(this.routeFilterPrefixes()));
            }
            case "bgpPeers": {
                return Optional.of(clazz.cast(this.bgpPeers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String virtualInterfaceId;
        private String location;
        private String connectionId;
        private String virtualInterfaceType;
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private Long amazonSideAsn;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private String virtualInterfaceState;
        private String customerRouterConfig;
        private String virtualGatewayId;
        private String directConnectGatewayId;
        private List<RouteFilterPrefix> routeFilterPrefixes;
        private List<BGPPeer> bgpPeers;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePublicVirtualInterfaceResponse model) {
            this.ownerAccount(model.ownerAccount);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.location(model.location);
            this.connectionId(model.connectionId);
            this.virtualInterfaceType(model.virtualInterfaceType);
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.amazonSideAsn(model.amazonSideAsn);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.addressFamily(model.addressFamily);
            this.virtualInterfaceState(model.virtualInterfaceState);
            this.customerRouterConfig(model.customerRouterConfig);
            this.virtualGatewayId(model.virtualGatewayId);
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.routeFilterPrefixes(model.routeFilterPrefixes);
            this.bgpPeers(model.bgpPeers);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getVirtualInterfaceType() {
            return this.virtualInterfaceType;
        }

        @Override
        public final Builder virtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
            return this;
        }

        public final void setVirtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getVirtualInterfaceState() {
            return this.virtualInterfaceState;
        }

        @Override
        public final Builder virtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
            return this;
        }

        @Override
        public final Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState) {
            this.virtualInterfaceState(virtualInterfaceState.toString());
            return this;
        }

        public final void setVirtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
        }

        public final String getCustomerRouterConfig() {
            return this.customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final Collection<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            return this.routeFilterPrefixes != null ? (Collection)this.routeFilterPrefixes.stream().map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        public final Collection<BGPPeer.Builder> getBgpPeers() {
            return this.bgpPeers != null ? (Collection)this.bgpPeers.stream().map(BGPPeer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bgpPeers(Collection<BGPPeer> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(BGPPeer ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final void setBgpPeers(Collection<BGPPeer.BuilderImpl> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copyFromBuilder(bgpPeers);
        }

        @Override
        public AllocatePublicVirtualInterfaceResponse build() {
            return new AllocatePublicVirtualInterfaceResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, AllocatePublicVirtualInterfaceResponse> {
        public Builder ownerAccount(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder location(String var1);

        public Builder connectionId(String var1);

        public Builder virtualInterfaceType(String var1);

        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder amazonSideAsn(Long var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder virtualInterfaceState(String var1);

        public Builder virtualInterfaceState(VirtualInterfaceState var1);

        public Builder customerRouterConfig(String var1);

        public Builder virtualGatewayId(String var1);

        public Builder directConnectGatewayId(String var1);

        public Builder routeFilterPrefixes(Collection<RouteFilterPrefix> var1);

        public Builder routeFilterPrefixes(RouteFilterPrefix ... var1);

        public Builder bgpPeers(Collection<BGPPeer> var1);

        public Builder bgpPeers(BGPPeer ... var1);
    }
}

