/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Lag;

@SdkInternalApi
public class LagMarshaller {
    private static final MarshallingInfo<String> CONNECTIONSBANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionsBandwidth").build();
    private static final MarshallingInfo<Integer> NUMBEROFCONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfConnections").build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").build();
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<String> LAGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagName").build();
    private static final MarshallingInfo<String> LAGSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagState").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<Integer> MINIMUMLINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumLinks").build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").build();
    private static final MarshallingInfo<List> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connections").build();
    private static final MarshallingInfo<Boolean> ALLOWSHOSTEDCONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowsHostedConnections").build();
    private static final LagMarshaller INSTANCE = new LagMarshaller();

    public static LagMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Lag lag, ProtocolMarshaller protocolMarshaller) {
        if (lag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lag.connectionsBandwidth(), CONNECTIONSBANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)lag.numberOfConnections(), NUMBEROFCONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)lag.lagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)lag.ownerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)lag.lagName(), LAGNAME_BINDING);
            protocolMarshaller.marshall((Object)lag.lagStateString(), LAGSTATE_BINDING);
            protocolMarshaller.marshall((Object)lag.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)lag.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)lag.minimumLinks(), MINIMUMLINKS_BINDING);
            protocolMarshaller.marshall((Object)lag.awsDevice(), AWSDEVICE_BINDING);
            protocolMarshaller.marshall(lag.connections(), CONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)lag.allowsHostedConnections(), ALLOWSHOSTEDCONNECTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

