/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState;
import software.amazon.awssdk.services.directconnect.transform.DirectConnectGatewayAttachmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DirectConnectGatewayAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectConnectGatewayAttachment> {
    private final String directConnectGatewayId;
    private final String virtualInterfaceId;
    private final String virtualInterfaceRegion;
    private final String virtualInterfaceOwnerAccount;
    private final String attachmentState;
    private final String stateChangeError;

    private DirectConnectGatewayAttachment(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.virtualInterfaceRegion = builder.virtualInterfaceRegion;
        this.virtualInterfaceOwnerAccount = builder.virtualInterfaceOwnerAccount;
        this.attachmentState = builder.attachmentState;
        this.stateChangeError = builder.stateChangeError;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public String virtualInterfaceRegion() {
        return this.virtualInterfaceRegion;
    }

    public String virtualInterfaceOwnerAccount() {
        return this.virtualInterfaceOwnerAccount;
    }

    public DirectConnectGatewayAttachmentState attachmentState() {
        return DirectConnectGatewayAttachmentState.fromValue(this.attachmentState);
    }

    public String attachmentStateString() {
        return this.attachmentState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAttachment)) {
            return false;
        }
        DirectConnectGatewayAttachment other = (DirectConnectGatewayAttachment)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.virtualInterfaceRegion(), other.virtualInterfaceRegion()) && Objects.equals(this.virtualInterfaceOwnerAccount(), other.virtualInterfaceOwnerAccount()) && Objects.equals(this.attachmentStateString(), other.attachmentStateString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directConnectGatewayId() != null) {
            sb.append("DirectConnectGatewayId: ").append(this.directConnectGatewayId()).append(",");
        }
        if (this.virtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.virtualInterfaceId()).append(",");
        }
        if (this.virtualInterfaceRegion() != null) {
            sb.append("VirtualInterfaceRegion: ").append(this.virtualInterfaceRegion()).append(",");
        }
        if (this.virtualInterfaceOwnerAccount() != null) {
            sb.append("VirtualInterfaceOwnerAccount: ").append(this.virtualInterfaceOwnerAccount()).append(",");
        }
        if (this.attachmentStateString() != null) {
            sb.append("AttachmentState: ").append(this.attachmentStateString()).append(",");
        }
        if (this.stateChangeError() != null) {
            sb.append("StateChangeError: ").append(this.stateChangeError()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.of(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "virtualInterfaceRegion": {
                return Optional.of(clazz.cast(this.virtualInterfaceRegion()));
            }
            case "virtualInterfaceOwnerAccount": {
                return Optional.of(clazz.cast(this.virtualInterfaceOwnerAccount()));
            }
            case "attachmentState": {
                return Optional.of(clazz.cast(this.attachmentStateString()));
            }
            case "stateChangeError": {
                return Optional.of(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectConnectGatewayAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualInterfaceId;
        private String virtualInterfaceRegion;
        private String virtualInterfaceOwnerAccount;
        private String attachmentState;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAttachment model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.virtualInterfaceRegion(model.virtualInterfaceRegion);
            this.virtualInterfaceOwnerAccount(model.virtualInterfaceOwnerAccount);
            this.attachmentState(model.attachmentState);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final String getVirtualInterfaceRegion() {
            return this.virtualInterfaceRegion;
        }

        @Override
        public final Builder virtualInterfaceRegion(String virtualInterfaceRegion) {
            this.virtualInterfaceRegion = virtualInterfaceRegion;
            return this;
        }

        public final void setVirtualInterfaceRegion(String virtualInterfaceRegion) {
            this.virtualInterfaceRegion = virtualInterfaceRegion;
        }

        public final String getVirtualInterfaceOwnerAccount() {
            return this.virtualInterfaceOwnerAccount;
        }

        @Override
        public final Builder virtualInterfaceOwnerAccount(String virtualInterfaceOwnerAccount) {
            this.virtualInterfaceOwnerAccount = virtualInterfaceOwnerAccount;
            return this;
        }

        public final void setVirtualInterfaceOwnerAccount(String virtualInterfaceOwnerAccount) {
            this.virtualInterfaceOwnerAccount = virtualInterfaceOwnerAccount;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Override
        public final Builder attachmentState(DirectConnectGatewayAttachmentState attachmentState) {
            this.attachmentState(attachmentState.toString());
            return this;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public DirectConnectGatewayAttachment build() {
            return new DirectConnectGatewayAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectConnectGatewayAttachment> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder virtualInterfaceRegion(String var1);

        public Builder virtualInterfaceOwnerAccount(String var1);

        public Builder attachmentState(String var1);

        public Builder attachmentState(DirectConnectGatewayAttachmentState var1);

        public Builder stateChangeError(String var1);
    }
}

