/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLagRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateLagRequest> {
    private final Integer numberOfConnections;
    private final String location;
    private final String connectionsBandwidth;
    private final String lagName;
    private final String connectionId;

    private CreateLagRequest(BuilderImpl builder) {
        super(builder);
        this.numberOfConnections = builder.numberOfConnections;
        this.location = builder.location;
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.lagName = builder.lagName;
        this.connectionId = builder.connectionId;
    }

    public Integer numberOfConnections() {
        return this.numberOfConnections;
    }

    public String location() {
        return this.location;
    }

    public String connectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public String lagName() {
        return this.lagName;
    }

    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLagRequest)) {
            return false;
        }
        CreateLagRequest other = (CreateLagRequest)((Object)obj);
        return Objects.equals(this.numberOfConnections(), other.numberOfConnections()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.connectionsBandwidth(), other.connectionsBandwidth()) && Objects.equals(this.lagName(), other.lagName()) && Objects.equals(this.connectionId(), other.connectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.numberOfConnections() != null) {
            sb.append("NumberOfConnections: ").append(this.numberOfConnections()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.connectionsBandwidth() != null) {
            sb.append("ConnectionsBandwidth: ").append(this.connectionsBandwidth()).append(",");
        }
        if (this.lagName() != null) {
            sb.append("LagName: ").append(this.lagName()).append(",");
        }
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberOfConnections": {
                return Optional.of(clazz.cast(this.numberOfConnections()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "connectionsBandwidth": {
                return Optional.of(clazz.cast(this.connectionsBandwidth()));
            }
            case "lagName": {
                return Optional.of(clazz.cast(this.lagName()));
            }
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private Integer numberOfConnections;
        private String location;
        private String connectionsBandwidth;
        private String lagName;
        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLagRequest model) {
            this.numberOfConnections(model.numberOfConnections);
            this.location(model.location);
            this.connectionsBandwidth(model.connectionsBandwidth);
            this.lagName(model.lagName);
            this.connectionId(model.connectionId);
        }

        public final Integer getNumberOfConnections() {
            return this.numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getConnectionsBandwidth() {
            return this.connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        public final String getLagName() {
            return this.lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLagRequest build() {
            return new CreateLagRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreateLagRequest> {
        public Builder numberOfConnections(Integer var1);

        public Builder location(String var1);

        public Builder connectionsBandwidth(String var1);

        public Builder lagName(String var1);

        public Builder connectionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

