/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeerState;
import software.amazon.awssdk.services.directconnect.model.BGPStatus;
import software.amazon.awssdk.services.directconnect.transform.BGPPeerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BGPPeer
implements StructuredPojo,
ToCopyableBuilder<Builder, BGPPeer> {
    private final Integer asn;
    private final String authKey;
    private final String addressFamily;
    private final String amazonAddress;
    private final String customerAddress;
    private final String bgpPeerState;
    private final String bgpStatus;

    private BGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerState = builder.bgpPeerState;
        this.bgpStatus = builder.bgpStatus;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyString() {
        return this.addressFamily;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public BGPPeerState bgpPeerState() {
        return BGPPeerState.fromValue(this.bgpPeerState);
    }

    public String bgpPeerStateString() {
        return this.bgpPeerState;
    }

    public BGPStatus bgpStatus() {
        return BGPStatus.fromValue(this.bgpStatus);
    }

    public String bgpStatusString() {
        return this.bgpStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpPeerStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpStatusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BGPPeer)) {
            return false;
        }
        BGPPeer other = (BGPPeer)obj;
        return Objects.equals(this.asn(), other.asn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.addressFamilyString(), other.addressFamilyString()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.bgpPeerStateString(), other.bgpPeerStateString()) && Objects.equals(this.bgpStatusString(), other.bgpStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.authKey() != null) {
            sb.append("AuthKey: ").append(this.authKey()).append(",");
        }
        if (this.addressFamilyString() != null) {
            sb.append("AddressFamily: ").append(this.addressFamilyString()).append(",");
        }
        if (this.amazonAddress() != null) {
            sb.append("AmazonAddress: ").append(this.amazonAddress()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        if (this.bgpPeerStateString() != null) {
            sb.append("BgpPeerState: ").append(this.bgpPeerStateString()).append(",");
        }
        if (this.bgpStatusString() != null) {
            sb.append("BgpStatus: ").append(this.bgpStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "asn": {
                return Optional.of(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.of(clazz.cast(this.authKey()));
            }
            case "addressFamily": {
                return Optional.of(clazz.cast(this.addressFamilyString()));
            }
            case "amazonAddress": {
                return Optional.of(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.of(clazz.cast(this.customerAddress()));
            }
            case "bgpPeerState": {
                return Optional.of(clazz.cast(this.bgpPeerStateString()));
            }
            case "bgpStatus": {
                return Optional.of(clazz.cast(this.bgpStatusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BGPPeerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer asn;
        private String authKey;
        private String addressFamily;
        private String amazonAddress;
        private String customerAddress;
        private String bgpPeerState;
        private String bgpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BGPPeer model) {
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.addressFamily(model.addressFamily);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.bgpPeerState(model.bgpPeerState);
            this.bgpStatus(model.bgpStatus);
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getBgpPeerState() {
            return this.bgpPeerState;
        }

        @Override
        public final Builder bgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
            return this;
        }

        @Override
        public final Builder bgpPeerState(BGPPeerState bgpPeerState) {
            this.bgpPeerState(bgpPeerState.toString());
            return this;
        }

        public final void setBgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
        }

        public final String getBgpStatus() {
            return this.bgpStatus;
        }

        @Override
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        public final Builder bgpStatus(BGPStatus bgpStatus) {
            this.bgpStatus(bgpStatus.toString());
            return this;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        public BGPPeer build() {
            return new BGPPeer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BGPPeer> {
        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder bgpPeerState(String var1);

        public Builder bgpPeerState(BGPPeerState var1);

        public Builder bgpStatus(String var1);

        public Builder bgpStatus(BGPStatus var1);
    }
}

