/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.NewBGPPeer;

@SdkInternalApi
public class NewBGPPeerMarshaller {
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").build();
    private static final NewBGPPeerMarshaller INSTANCE = new NewBGPPeerMarshaller();

    public static NewBGPPeerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NewBGPPeer newBGPPeer, ProtocolMarshaller protocolMarshaller) {
        if (newBGPPeer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)newBGPPeer.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)newBGPPeer.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)newBGPPeer.addressFamilyString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)newBGPPeer.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newBGPPeer.customerAddress(), CUSTOMERADDRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

