/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.directconnect.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UntagResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UntagResourceRequest> {
    private final String resourceArn;
    private final List<String> tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "tagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            this.resourceArn(model.resourceArn);
            this.tagKeys(model.tagKeys);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UntagResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);
    }
}

