/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.VirtualInterface;
import software.amazon.awssdk.services.directconnect.model.VirtualInterfaceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVirtualInterfacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVirtualInterfacesResponse> {
    private final List<VirtualInterface> virtualInterfaces;

    private DescribeVirtualInterfacesResponse(BuilderImpl builder) {
        this.virtualInterfaces = builder.virtualInterfaces;
    }

    public List<VirtualInterface> virtualInterfaces() {
        return this.virtualInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualInterfacesResponse)) {
            return false;
        }
        DescribeVirtualInterfacesResponse other = (DescribeVirtualInterfacesResponse)((Object)obj);
        return Objects.equals(this.virtualInterfaces(), other.virtualInterfaces());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.virtualInterfaces() != null) {
            sb.append("VirtualInterfaces: ").append(this.virtualInterfaces()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaces": {
                return Optional.of(clazz.cast(this.virtualInterfaces()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VirtualInterface> virtualInterfaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualInterfacesResponse model) {
            this.virtualInterfaces(model.virtualInterfaces);
        }

        public final Collection<VirtualInterface.Builder> getVirtualInterfaces() {
            return this.virtualInterfaces != null ? (Collection)this.virtualInterfaces.stream().map(VirtualInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualInterfaces(Collection<VirtualInterface> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copy(virtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaces(VirtualInterface ... virtualInterfaces) {
            this.virtualInterfaces(Arrays.asList(virtualInterfaces));
            return this;
        }

        public final void setVirtualInterfaces(Collection<VirtualInterface.BuilderImpl> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copyFromBuilder(virtualInterfaces);
        }

        public DescribeVirtualInterfacesResponse build() {
            return new DescribeVirtualInterfacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVirtualInterfacesResponse> {
        public Builder virtualInterfaces(Collection<VirtualInterface> var1);

        public Builder virtualInterfaces(VirtualInterface ... var1);
    }
}

