/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterface;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePublicVirtualInterfaceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePublicVirtualInterfaceRequest> {
    private final String connectionId;
    private final NewPublicVirtualInterface newPublicVirtualInterface;

    private CreatePublicVirtualInterfaceRequest(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.newPublicVirtualInterface = builder.newPublicVirtualInterface;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public NewPublicVirtualInterface newPublicVirtualInterface() {
        return this.newPublicVirtualInterface;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPublicVirtualInterface());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicVirtualInterfaceRequest)) {
            return false;
        }
        CreatePublicVirtualInterfaceRequest other = (CreatePublicVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.newPublicVirtualInterface(), other.newPublicVirtualInterface());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.newPublicVirtualInterface() != null) {
            sb.append("NewPublicVirtualInterface: ").append(this.newPublicVirtualInterface()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "newPublicVirtualInterface": {
                return Optional.of(clazz.cast(this.newPublicVirtualInterface()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private NewPublicVirtualInterface newPublicVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicVirtualInterfaceRequest model) {
            this.connectionId(model.connectionId);
            this.newPublicVirtualInterface(model.newPublicVirtualInterface);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final NewPublicVirtualInterface.Builder getNewPublicVirtualInterface() {
            return this.newPublicVirtualInterface != null ? this.newPublicVirtualInterface.toBuilder() : null;
        }

        @Override
        public final Builder newPublicVirtualInterface(NewPublicVirtualInterface newPublicVirtualInterface) {
            this.newPublicVirtualInterface = newPublicVirtualInterface;
            return this;
        }

        public final void setNewPublicVirtualInterface(NewPublicVirtualInterface.BuilderImpl newPublicVirtualInterface) {
            this.newPublicVirtualInterface = newPublicVirtualInterface != null ? newPublicVirtualInterface.build() : null;
        }

        public CreatePublicVirtualInterfaceRequest build() {
            return new CreatePublicVirtualInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePublicVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder newPublicVirtualInterface(NewPublicVirtualInterface var1);

        default public Builder newPublicVirtualInterface(Consumer<NewPublicVirtualInterface.Builder> newPublicVirtualInterface) {
            return this.newPublicVirtualInterface((NewPublicVirtualInterface)((NewPublicVirtualInterface.Builder)NewPublicVirtualInterface.builder().apply(newPublicVirtualInterface)).build());
        }
    }
}

