/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.InterconnectState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInterconnectResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateInterconnectResponse> {
    private final String interconnectId;
    private final String interconnectName;
    private final String interconnectState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;

    private CreateInterconnectResponse(BuilderImpl builder) {
        this.interconnectId = builder.interconnectId;
        this.interconnectName = builder.interconnectName;
        this.interconnectState = builder.interconnectState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String interconnectName() {
        return this.interconnectName;
    }

    public InterconnectState interconnectState() {
        return InterconnectState.fromValue(this.interconnectState);
    }

    public String interconnectStateString() {
        return this.interconnectState;
    }

    public String region() {
        return this.region;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public String lagId() {
        return this.lagId;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInterconnectResponse)) {
            return false;
        }
        CreateInterconnectResponse other = (CreateInterconnectResponse)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId()) && Objects.equals(this.interconnectName(), other.interconnectName()) && Objects.equals(this.interconnectStateString(), other.interconnectStateString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.interconnectId() != null) {
            sb.append("InterconnectId: ").append(this.interconnectId()).append(",");
        }
        if (this.interconnectName() != null) {
            sb.append("InterconnectName: ").append(this.interconnectName()).append(",");
        }
        if (this.interconnectStateString() != null) {
            sb.append("InterconnectState: ").append(this.interconnectStateString()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.bandwidth() != null) {
            sb.append("Bandwidth: ").append(this.bandwidth()).append(",");
        }
        if (this.loaIssueTime() != null) {
            sb.append("LoaIssueTime: ").append(this.loaIssueTime()).append(",");
        }
        if (this.lagId() != null) {
            sb.append("LagId: ").append(this.lagId()).append(",");
        }
        if (this.awsDevice() != null) {
            sb.append("AwsDevice: ").append(this.awsDevice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.of(clazz.cast(this.interconnectId()));
            }
            case "interconnectName": {
                return Optional.of(clazz.cast(this.interconnectName()));
            }
            case "interconnectState": {
                return Optional.of(clazz.cast(this.interconnectStateString()));
            }
            case "region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.of(clazz.cast(this.bandwidth()));
            }
            case "loaIssueTime": {
                return Optional.of(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.of(clazz.cast(this.awsDevice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String interconnectId;
        private String interconnectName;
        private String interconnectState;
        private String region;
        private String location;
        private String bandwidth;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInterconnectResponse model) {
            this.interconnectId(model.interconnectId);
            this.interconnectName(model.interconnectName);
            this.interconnectState(model.interconnectState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getInterconnectName() {
            return this.interconnectName;
        }

        @Override
        public final Builder interconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public final void setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
        }

        public final String getInterconnectState() {
            return this.interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState.toString());
            return this;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public CreateInterconnectResponse build() {
            return new CreateInterconnectResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInterconnectResponse> {
        public Builder interconnectId(String var1);

        public Builder interconnectName(String var1);

        public Builder interconnectState(String var1);

        public Builder interconnectState(InterconnectState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);
    }
}

