/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.directconnect.model.VirtualInterface;
import software.amazon.awssdk.services.directconnect.transform.BGPPeerUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.RouteFilterPrefixUnmarshaller;

public class VirtualInterfaceUnmarshaller
implements Unmarshaller<VirtualInterface, JsonUnmarshallerContext> {
    private static final VirtualInterfaceUnmarshaller INSTANCE = new VirtualInterfaceUnmarshaller();

    public VirtualInterface unmarshall(JsonUnmarshallerContext context) throws Exception {
        VirtualInterface.Builder virtualInterfaceBuilder = VirtualInterface.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ownerAccount", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.ownerAccount((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("virtualInterfaceId", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.virtualInterfaceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("connectionId", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.connectionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("virtualInterfaceType", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.virtualInterfaceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("virtualInterfaceName", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.virtualInterfaceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("vlan", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.vlan((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("asn", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.asn((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("authKey", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.authKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("amazonAddress", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.amazonAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("customerAddress", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.customerAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("addressFamily", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.addressFamily((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("virtualInterfaceState", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.virtualInterfaceState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("customerRouterConfig", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.customerRouterConfig((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("virtualGatewayId", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.virtualGatewayId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("routeFilterPrefixes", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.routeFilterPrefixes(new ListUnmarshaller((Unmarshaller)RouteFilterPrefixUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("bgpPeers", targetDepth)) {
                    context.nextToken();
                    virtualInterfaceBuilder.bgpPeers(new ListUnmarshaller((Unmarshaller)BGPPeerUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VirtualInterface)virtualInterfaceBuilder.build();
    }

    public static VirtualInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

