/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Connection;

@SdkInternalApi
public class ConnectionMarshaller {
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").build();
    private static final MarshallingInfo<String> CONNECTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionName").build();
    private static final MarshallingInfo<String> CONNECTIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionState").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").build();
    private static final MarshallingInfo<String> PARTNERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partnerName").build();
    private static final MarshallingInfo<Instant> LOAISSUETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaIssueTime").build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").build();
    private static final ConnectionMarshaller INSTANCE = new ConnectionMarshaller();

    public static ConnectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Connection connection, ProtocolMarshaller protocolMarshaller) {
        if (connection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connection.ownerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)connection.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)connection.connectionName(), CONNECTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)connection.connectionState(), CONNECTIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)connection.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)connection.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)connection.bandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)connection.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)connection.partnerName(), PARTNERNAME_BINDING);
            protocolMarshaller.marshall((Object)connection.loaIssueTime(), LOAISSUETIME_BINDING);
            protocolMarshaller.marshall((Object)connection.lagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)connection.awsDevice(), AWSDEVICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

