/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.Interconnect;
import software.amazon.awssdk.services.directconnect.model.InterconnectListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInterconnectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInterconnectsResponse> {
    private final List<Interconnect> interconnects;

    private DescribeInterconnectsResponse(BuilderImpl builder) {
        this.interconnects = builder.interconnects;
    }

    public List<Interconnect> interconnects() {
        return this.interconnects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.interconnects() == null ? 0 : this.interconnects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectsResponse)) {
            return false;
        }
        DescribeInterconnectsResponse other = (DescribeInterconnectsResponse)((Object)obj);
        if (other.interconnects() == null ^ this.interconnects() == null) {
            return false;
        }
        return other.interconnects() == null || other.interconnects().equals(this.interconnects());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.interconnects() != null) {
            sb.append("Interconnects: ").append(this.interconnects()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Interconnect> interconnects;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectsResponse model) {
            this.setInterconnects(model.interconnects);
        }

        public final Collection<Interconnect> getInterconnects() {
            return this.interconnects;
        }

        @Override
        public final Builder interconnects(Collection<Interconnect> interconnects) {
            this.interconnects = InterconnectListCopier.copy(interconnects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interconnects(Interconnect ... interconnects) {
            this.interconnects(Arrays.asList(interconnects));
            return this;
        }

        public final void setInterconnects(Collection<Interconnect> interconnects) {
            this.interconnects = InterconnectListCopier.copy(interconnects);
        }

        public DescribeInterconnectsResponse build() {
            return new DescribeInterconnectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInterconnectsResponse> {
        public Builder interconnects(Collection<Interconnect> var1);

        public Builder interconnects(Interconnect ... var1);
    }
}

