/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.services.directconnect.model.LagState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLagResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteLagResponse> {
    private final String connectionsBandwidth;
    private final Integer numberOfConnections;
    private final String lagId;
    private final String ownerAccount;
    private final String lagName;
    private final String lagState;
    private final String location;
    private final String region;
    private final Integer minimumLinks;
    private final String awsDevice;
    private final List<Connection> connections;
    private final Boolean allowsHostedConnections;

    private DeleteLagResponse(BuilderImpl builder) {
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.numberOfConnections = builder.numberOfConnections;
        this.lagId = builder.lagId;
        this.ownerAccount = builder.ownerAccount;
        this.lagName = builder.lagName;
        this.lagState = builder.lagState;
        this.location = builder.location;
        this.region = builder.region;
        this.minimumLinks = builder.minimumLinks;
        this.awsDevice = builder.awsDevice;
        this.connections = builder.connections;
        this.allowsHostedConnections = builder.allowsHostedConnections;
    }

    public String connectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public Integer numberOfConnections() {
        return this.numberOfConnections;
    }

    public String lagId() {
        return this.lagId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String lagName() {
        return this.lagName;
    }

    public String lagState() {
        return this.lagState;
    }

    public String location() {
        return this.location;
    }

    public String region() {
        return this.region;
    }

    public Integer minimumLinks() {
        return this.minimumLinks;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Boolean allowsHostedConnections() {
        return this.allowsHostedConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionsBandwidth() == null ? 0 : this.connectionsBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.numberOfConnections() == null ? 0 : this.numberOfConnections().hashCode());
        hashCode = 31 * hashCode + (this.lagId() == null ? 0 : this.lagId().hashCode());
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.lagName() == null ? 0 : this.lagName().hashCode());
        hashCode = 31 * hashCode + (this.lagState() == null ? 0 : this.lagState().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.minimumLinks() == null ? 0 : this.minimumLinks().hashCode());
        hashCode = 31 * hashCode + (this.awsDevice() == null ? 0 : this.awsDevice().hashCode());
        hashCode = 31 * hashCode + (this.connections() == null ? 0 : this.connections().hashCode());
        hashCode = 31 * hashCode + (this.allowsHostedConnections() == null ? 0 : this.allowsHostedConnections().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLagResponse)) {
            return false;
        }
        DeleteLagResponse other = (DeleteLagResponse)((Object)obj);
        if (other.connectionsBandwidth() == null ^ this.connectionsBandwidth() == null) {
            return false;
        }
        if (other.connectionsBandwidth() != null && !other.connectionsBandwidth().equals(this.connectionsBandwidth())) {
            return false;
        }
        if (other.numberOfConnections() == null ^ this.numberOfConnections() == null) {
            return false;
        }
        if (other.numberOfConnections() != null && !other.numberOfConnections().equals(this.numberOfConnections())) {
            return false;
        }
        if (other.lagId() == null ^ this.lagId() == null) {
            return false;
        }
        if (other.lagId() != null && !other.lagId().equals(this.lagId())) {
            return false;
        }
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.lagName() == null ^ this.lagName() == null) {
            return false;
        }
        if (other.lagName() != null && !other.lagName().equals(this.lagName())) {
            return false;
        }
        if (other.lagState() == null ^ this.lagState() == null) {
            return false;
        }
        if (other.lagState() != null && !other.lagState().equals(this.lagState())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.minimumLinks() == null ^ this.minimumLinks() == null) {
            return false;
        }
        if (other.minimumLinks() != null && !other.minimumLinks().equals(this.minimumLinks())) {
            return false;
        }
        if (other.awsDevice() == null ^ this.awsDevice() == null) {
            return false;
        }
        if (other.awsDevice() != null && !other.awsDevice().equals(this.awsDevice())) {
            return false;
        }
        if (other.connections() == null ^ this.connections() == null) {
            return false;
        }
        if (other.connections() != null && !other.connections().equals(this.connections())) {
            return false;
        }
        if (other.allowsHostedConnections() == null ^ this.allowsHostedConnections() == null) {
            return false;
        }
        return other.allowsHostedConnections() == null || other.allowsHostedConnections().equals(this.allowsHostedConnections());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionsBandwidth() != null) {
            sb.append("ConnectionsBandwidth: ").append(this.connectionsBandwidth()).append(",");
        }
        if (this.numberOfConnections() != null) {
            sb.append("NumberOfConnections: ").append(this.numberOfConnections()).append(",");
        }
        if (this.lagId() != null) {
            sb.append("LagId: ").append(this.lagId()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.lagName() != null) {
            sb.append("LagName: ").append(this.lagName()).append(",");
        }
        if (this.lagState() != null) {
            sb.append("LagState: ").append(this.lagState()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.minimumLinks() != null) {
            sb.append("MinimumLinks: ").append(this.minimumLinks()).append(",");
        }
        if (this.awsDevice() != null) {
            sb.append("AwsDevice: ").append(this.awsDevice()).append(",");
        }
        if (this.connections() != null) {
            sb.append("Connections: ").append(this.connections()).append(",");
        }
        if (this.allowsHostedConnections() != null) {
            sb.append("AllowsHostedConnections: ").append(this.allowsHostedConnections()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String connectionsBandwidth;
        private Integer numberOfConnections;
        private String lagId;
        private String ownerAccount;
        private String lagName;
        private String lagState;
        private String location;
        private String region;
        private Integer minimumLinks;
        private String awsDevice;
        private List<Connection> connections;
        private Boolean allowsHostedConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLagResponse model) {
            this.setConnectionsBandwidth(model.connectionsBandwidth);
            this.setNumberOfConnections(model.numberOfConnections);
            this.setLagId(model.lagId);
            this.setOwnerAccount(model.ownerAccount);
            this.setLagName(model.lagName);
            this.setLagState(model.lagState);
            this.setLocation(model.location);
            this.setRegion(model.region);
            this.setMinimumLinks(model.minimumLinks);
            this.setAwsDevice(model.awsDevice);
            this.setConnections(model.connections);
            this.setAllowsHostedConnections(model.allowsHostedConnections);
        }

        public final String getConnectionsBandwidth() {
            return this.connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        public final Integer getNumberOfConnections() {
            return this.numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getLagName() {
            return this.lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final String getLagState() {
            return this.lagState;
        }

        @Override
        public final Builder lagState(String lagState) {
            this.lagState = lagState;
            return this;
        }

        @Override
        public final Builder lagState(LagState lagState) {
            this.lagState(lagState.toString());
            return this;
        }

        public final void setLagState(String lagState) {
            this.lagState = lagState;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Integer getMinimumLinks() {
            return this.minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Collection<Connection> getConnections() {
            return this.connections;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
        }

        public final Boolean getAllowsHostedConnections() {
            return this.allowsHostedConnections;
        }

        @Override
        public final Builder allowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
            return this;
        }

        public final void setAllowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
        }

        public DeleteLagResponse build() {
            return new DeleteLagResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteLagResponse> {
        public Builder connectionsBandwidth(String var1);

        public Builder numberOfConnections(Integer var1);

        public Builder lagId(String var1);

        public Builder ownerAccount(String var1);

        public Builder lagName(String var1);

        public Builder lagState(String var1);

        public Builder lagState(LagState var1);

        public Builder location(String var1);

        public Builder region(String var1);

        public Builder minimumLinks(Integer var1);

        public Builder awsDevice(String var1);

        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);

        public Builder allowsHostedConnections(Boolean var1);
    }
}

