/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInterconnectLoaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
    private final String interconnectId;
    private final String providerName;
    private final String loaContentType;

    private DescribeInterconnectLoaRequest(BuilderImpl builder) {
        this.interconnectId = builder.interconnectId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String providerName() {
        return this.providerName;
    }

    public String loaContentType() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.interconnectId() == null ? 0 : this.interconnectId().hashCode());
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.loaContentType() == null ? 0 : this.loaContentType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectLoaRequest)) {
            return false;
        }
        DescribeInterconnectLoaRequest other = (DescribeInterconnectLoaRequest)((Object)obj);
        if (other.interconnectId() == null ^ this.interconnectId() == null) {
            return false;
        }
        if (other.interconnectId() != null && !other.interconnectId().equals(this.interconnectId())) {
            return false;
        }
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.loaContentType() == null ^ this.loaContentType() == null) {
            return false;
        }
        return other.loaContentType() == null || other.loaContentType().equals(this.loaContentType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.interconnectId() != null) {
            sb.append("InterconnectId: ").append(this.interconnectId()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.loaContentType() != null) {
            sb.append("LoaContentType: ").append(this.loaContentType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String interconnectId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectLoaRequest model) {
            this.setInterconnectId(model.interconnectId);
            this.setProviderName(model.providerName);
            this.setLoaContentType(model.loaContentType);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        public DescribeInterconnectLoaRequest build() {
            return new DescribeInterconnectLoaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
        public Builder interconnectId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

