/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix;
import software.amazon.awssdk.services.directconnect.model.RouteFilterPrefixListCopier;
import software.amazon.awssdk.services.directconnect.transform.NewPublicVirtualInterfaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NewPublicVirtualInterface
implements StructuredPojo,
ToCopyableBuilder<Builder, NewPublicVirtualInterface> {
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final String authKey;
    private final String amazonAddress;
    private final String customerAddress;
    private final String addressFamily;
    private final List<RouteFilterPrefix> routeFilterPrefixes;

    private NewPublicVirtualInterface(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
    }

    public String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public String addressFamily() {
        return this.addressFamily;
    }

    public List<RouteFilterPrefix> routeFilterPrefixes() {
        return this.routeFilterPrefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.virtualInterfaceName() == null ? 0 : this.virtualInterfaceName().hashCode());
        hashCode = 31 * hashCode + (this.vlan() == null ? 0 : this.vlan().hashCode());
        hashCode = 31 * hashCode + (this.asn() == null ? 0 : this.asn().hashCode());
        hashCode = 31 * hashCode + (this.authKey() == null ? 0 : this.authKey().hashCode());
        hashCode = 31 * hashCode + (this.amazonAddress() == null ? 0 : this.amazonAddress().hashCode());
        hashCode = 31 * hashCode + (this.customerAddress() == null ? 0 : this.customerAddress().hashCode());
        hashCode = 31 * hashCode + (this.addressFamily() == null ? 0 : this.addressFamily().hashCode());
        hashCode = 31 * hashCode + (this.routeFilterPrefixes() == null ? 0 : this.routeFilterPrefixes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPublicVirtualInterface)) {
            return false;
        }
        NewPublicVirtualInterface other = (NewPublicVirtualInterface)obj;
        if (other.virtualInterfaceName() == null ^ this.virtualInterfaceName() == null) {
            return false;
        }
        if (other.virtualInterfaceName() != null && !other.virtualInterfaceName().equals(this.virtualInterfaceName())) {
            return false;
        }
        if (other.vlan() == null ^ this.vlan() == null) {
            return false;
        }
        if (other.vlan() != null && !other.vlan().equals(this.vlan())) {
            return false;
        }
        if (other.asn() == null ^ this.asn() == null) {
            return false;
        }
        if (other.asn() != null && !other.asn().equals(this.asn())) {
            return false;
        }
        if (other.authKey() == null ^ this.authKey() == null) {
            return false;
        }
        if (other.authKey() != null && !other.authKey().equals(this.authKey())) {
            return false;
        }
        if (other.amazonAddress() == null ^ this.amazonAddress() == null) {
            return false;
        }
        if (other.amazonAddress() != null && !other.amazonAddress().equals(this.amazonAddress())) {
            return false;
        }
        if (other.customerAddress() == null ^ this.customerAddress() == null) {
            return false;
        }
        if (other.customerAddress() != null && !other.customerAddress().equals(this.customerAddress())) {
            return false;
        }
        if (other.addressFamily() == null ^ this.addressFamily() == null) {
            return false;
        }
        if (other.addressFamily() != null && !other.addressFamily().equals(this.addressFamily())) {
            return false;
        }
        if (other.routeFilterPrefixes() == null ^ this.routeFilterPrefixes() == null) {
            return false;
        }
        return other.routeFilterPrefixes() == null || other.routeFilterPrefixes().equals(this.routeFilterPrefixes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.virtualInterfaceName() != null) {
            sb.append("VirtualInterfaceName: ").append(this.virtualInterfaceName()).append(",");
        }
        if (this.vlan() != null) {
            sb.append("Vlan: ").append(this.vlan()).append(",");
        }
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.authKey() != null) {
            sb.append("AuthKey: ").append(this.authKey()).append(",");
        }
        if (this.amazonAddress() != null) {
            sb.append("AmazonAddress: ").append(this.amazonAddress()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        if (this.addressFamily() != null) {
            sb.append("AddressFamily: ").append(this.addressFamily()).append(",");
        }
        if (this.routeFilterPrefixes() != null) {
            sb.append("RouteFilterPrefixes: ").append(this.routeFilterPrefixes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewPublicVirtualInterfaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private String authKey;
        private String amazonAddress;
        private String customerAddress;
        private String addressFamily;
        private List<RouteFilterPrefix> routeFilterPrefixes;

        private BuilderImpl() {
        }

        private BuilderImpl(NewPublicVirtualInterface model) {
            this.setVirtualInterfaceName(model.virtualInterfaceName);
            this.setVlan(model.vlan);
            this.setAsn(model.asn);
            this.setAuthKey(model.authKey);
            this.setAmazonAddress(model.amazonAddress);
            this.setCustomerAddress(model.customerAddress);
            this.setAddressFamily(model.addressFamily);
            this.setRouteFilterPrefixes(model.routeFilterPrefixes);
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final void setAddressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
        }

        public final Collection<RouteFilterPrefix> getRouteFilterPrefixes() {
            return this.routeFilterPrefixes;
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
        }

        @SafeVarargs
        public final void setRouteFilterPrefixes(RouteFilterPrefix ... routeFilterPrefixes) {
            this.routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
        }

        public NewPublicVirtualInterface build() {
            return new NewPublicVirtualInterface(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NewPublicVirtualInterface> {
        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder routeFilterPrefixes(Collection<RouteFilterPrefix> var1);

        public Builder routeFilterPrefixes(RouteFilterPrefix ... var1);
    }
}

