/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConnectionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeConnectionsResponse> {
    private final List<Connection> connections;

    private DescribeConnectionsResponse(BuilderImpl builder) {
        this.connections = builder.connections;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connections() == null ? 0 : this.connections().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionsResponse)) {
            return false;
        }
        DescribeConnectionsResponse other = (DescribeConnectionsResponse)((Object)obj);
        if (other.connections() == null ^ this.connections() == null) {
            return false;
        }
        return other.connections() == null || other.connections().equals(this.connections());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connections() != null) {
            sb.append("Connections: ").append(this.connections()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Connection> connections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionsResponse model) {
            this.setConnections(model.connections);
        }

        public final Collection<Connection> getConnections() {
            return this.connections;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
        }

        @SafeVarargs
        public final void setConnections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
        }

        public DescribeConnectionsResponse build() {
            return new DescribeConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConnectionsResponse> {
        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);
    }
}

