/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionsOnInterconnectResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeConnectionsOnInterconnectResponse> {
    private static final SdkField<List<Connection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConnectionsOnInterconnectResponse.getter(DescribeConnectionsOnInterconnectResponse::connections)).setter(DescribeConnectionsOnInterconnectResponse.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Connection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD));
    private final List<Connection> connections;

    private DescribeConnectionsOnInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionsOnInterconnectResponse)) {
            return false;
        }
        DescribeConnectionsOnInterconnectResponse other = (DescribeConnectionsOnInterconnectResponse)((Object)obj);
        return Objects.equals(this.connections(), other.connections());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectionsOnInterconnectResponse").add("Connections", this.connections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionsOnInterconnectResponse, T> g) {
        return obj -> g.apply((DescribeConnectionsOnInterconnectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Connection> connections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionsOnInterconnectResponse model) {
            super(model);
            this.connections(model.connections);
        }

        public final Collection<Connection.Builder> getConnections() {
            return this.connections != null ? (Collection)this.connections.stream().map(Connection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<Connection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (Connection)((Connection.Builder)Connection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public DescribeConnectionsOnInterconnectResponse build() {
            return new DescribeConnectionsOnInterconnectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionsOnInterconnectResponse> {
        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);

        public Builder connections(Consumer<Connection.Builder> ... var1);
    }
}

