/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NewPrivateVirtualInterfaceAllocationMarshaller {
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").isBinary(false).build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").isBinary(false).build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").isBinary(false).build();
    private static final NewPrivateVirtualInterfaceAllocationMarshaller INSTANCE = new NewPrivateVirtualInterfaceAllocationMarshaller();

    private NewPrivateVirtualInterfaceAllocationMarshaller() {
    }

    public static NewPrivateVirtualInterfaceAllocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)newPrivateVirtualInterfaceAllocation, (String)"newPrivateVirtualInterfaceAllocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.virtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.addressFamilyAsString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterfaceAllocation.customerAddress(), CUSTOMERADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

