/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeVirtualGatewaysRequestMarshaller
implements Marshaller<Request<DescribeVirtualGatewaysRequest>, DescribeVirtualGatewaysRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(false).operationIdentifier("OvertureService.DescribeVirtualGateways").serviceName("AWS Direct Connect").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeVirtualGatewaysRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeVirtualGatewaysRequest> marshall(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) {
        Validate.paramNotNull((Object)((Object)describeVirtualGatewaysRequest), (String)"describeVirtualGatewaysRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeVirtualGatewaysRequest);
            protocolMarshaller.startMarshalling();
            DescribeVirtualGatewaysRequestModelMarshaller.getInstance().marshall(describeVirtualGatewaysRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

