/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.transform.NewPrivateVirtualInterfaceAllocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewPrivateVirtualInterfaceAllocation
implements StructuredPojo,
ToCopyableBuilder<Builder, NewPrivateVirtualInterfaceAllocation> {
    private final String virtualInterfaceName;
    private final Integer vlan;
    private final Integer asn;
    private final String authKey;
    private final String amazonAddress;
    private final String addressFamily;
    private final String customerAddress;

    private NewPrivateVirtualInterfaceAllocation(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.addressFamily = builder.addressFamily;
        this.customerAddress = builder.customerAddress;
    }

    public String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyAsString() {
        return this.addressFamily;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPrivateVirtualInterfaceAllocation)) {
            return false;
        }
        NewPrivateVirtualInterfaceAllocation other = (NewPrivateVirtualInterfaceAllocation)obj;
        return Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.customerAddress(), other.customerAddress());
    }

    public String toString() {
        return ToString.builder((String)"NewPrivateVirtualInterfaceAllocation").add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).add("Vlan", (Object)this.vlan()).add("Asn", (Object)this.asn()).add("AuthKey", (Object)this.authKey()).add("AmazonAddress", (Object)this.amazonAddress()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("CustomerAddress", (Object)this.customerAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewPrivateVirtualInterfaceAllocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceName;
        private Integer vlan;
        private Integer asn;
        private String authKey;
        private String amazonAddress;
        private String addressFamily;
        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NewPrivateVirtualInterfaceAllocation model) {
            this.virtualInterfaceName(model.virtualInterfaceName);
            this.vlan(model.vlan);
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.amazonAddress(model.amazonAddress);
            this.addressFamily(model.addressFamily);
            this.customerAddress(model.customerAddress);
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public NewPrivateVirtualInterfaceAllocation build() {
            return new NewPrivateVirtualInterfaceAllocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NewPrivateVirtualInterfaceAllocation> {
        public Builder virtualInterfaceName(String var1);

        public Builder vlan(Integer var1);

        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder amazonAddress(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder customerAddress(String var1);
    }
}

