/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.Location;
import software.amazon.awssdk.services.directconnect.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeLocationsResponse> {
    private final List<Location> locations;

    private DescribeLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.locations = builder.locations;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationsResponse)) {
            return false;
        }
        DescribeLocationsResponse other = (DescribeLocationsResponse)((Object)obj);
        return Objects.equals(this.locations(), other.locations());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLocationsResponse").add("Locations", this.locations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Location> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationsResponse model) {
            super(model);
            this.locations(model.locations);
        }

        public final Collection<Location.Builder> getLocations() {
            return this.locations != null ? (Collection)this.locations.stream().map(Location::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<Location.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (Location)((Location.Builder)Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocations(Collection<Location.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        @Override
        public DescribeLocationsResponse build() {
            return new DescribeLocationsResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeLocationsResponse> {
        public Builder locations(Collection<Location> var1);

        public Builder locations(Location ... var1);

        public Builder locations(Consumer<Location.Builder> ... var1);
    }
}

