/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.InterconnectState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInterconnectResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, CreateInterconnectResponse> {
    private final String interconnectId;
    private final String interconnectName;
    private final String interconnectState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final String awsDeviceV2;

    private CreateInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.interconnectId = builder.interconnectId;
        this.interconnectName = builder.interconnectName;
        this.interconnectState = builder.interconnectState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.awsDeviceV2 = builder.awsDeviceV2;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String interconnectName() {
        return this.interconnectName;
    }

    public InterconnectState interconnectState() {
        return InterconnectState.fromValue(this.interconnectState);
    }

    public String interconnectStateAsString() {
        return this.interconnectState;
    }

    public String region() {
        return this.region;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public String lagId() {
        return this.lagId;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInterconnectResponse)) {
            return false;
        }
        CreateInterconnectResponse other = (CreateInterconnectResponse)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId()) && Objects.equals(this.interconnectName(), other.interconnectName()) && Objects.equals(this.interconnectStateAsString(), other.interconnectStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2());
    }

    public String toString() {
        return ToString.builder((String)"CreateInterconnectResponse").add("InterconnectId", (Object)this.interconnectId()).add("InterconnectName", (Object)this.interconnectName()).add("InterconnectState", (Object)this.interconnectStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.ofNullable(clazz.cast(this.interconnectId()));
            }
            case "interconnectName": {
                return Optional.ofNullable(clazz.cast(this.interconnectName()));
            }
            case "interconnectState": {
                return Optional.ofNullable(clazz.cast(this.interconnectStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String interconnectId;
        private String interconnectName;
        private String interconnectState;
        private String region;
        private String location;
        private String bandwidth;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private String awsDeviceV2;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInterconnectResponse model) {
            super(model);
            this.interconnectId(model.interconnectId);
            this.interconnectName(model.interconnectName);
            this.interconnectState(model.interconnectState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.awsDeviceV2(model.awsDeviceV2);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getInterconnectName() {
            return this.interconnectName;
        }

        @Override
        public final Builder interconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public final void setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
        }

        public final String getInterconnectState() {
            return this.interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState.toString());
            return this;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public CreateInterconnectResponse build() {
            return new CreateInterconnectResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, CreateInterconnectResponse> {
        public Builder interconnectId(String var1);

        public Builder interconnectName(String var1);

        public Builder interconnectState(String var1);

        public Builder interconnectState(InterconnectState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder awsDeviceV2(String var1);
    }
}

