/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.directconnect.model.ConnectionState;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, CreateConnectionResponse> {
    private final String ownerAccount;
    private final String connectionId;
    private final String connectionName;
    private final String connectionState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Integer vlan;
    private final String partnerName;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final String awsDeviceV2;

    private CreateConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.connectionId = builder.connectionId;
        this.connectionName = builder.connectionName;
        this.connectionState = builder.connectionState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.vlan = builder.vlan;
        this.partnerName = builder.partnerName;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.awsDeviceV2 = builder.awsDeviceV2;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public String connectionStateAsString() {
        return this.connectionState;
    }

    public String region() {
        return this.region;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public String partnerName() {
        return this.partnerName;
    }

    public Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public String lagId() {
        return this.lagId;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionResponse)) {
            return false;
        }
        CreateConnectionResponse other = (CreateConnectionResponse)((Object)obj);
        return Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.partnerName(), other.partnerName()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2());
    }

    public String toString() {
        return ToString.builder((String)"CreateConnectionResponse").add("OwnerAccount", (Object)this.ownerAccount()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionName", (Object)this.connectionName()).add("ConnectionState", (Object)this.connectionStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("Vlan", (Object)this.vlan()).add("PartnerName", (Object)this.partnerName()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "connectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "connectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "partnerName": {
                return Optional.ofNullable(clazz.cast(this.partnerName()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String connectionId;
        private String connectionName;
        private String connectionState;
        private String region;
        private String location;
        private String bandwidth;
        private Integer vlan;
        private String partnerName;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private String awsDeviceV2;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionResponse model) {
            super(model);
            this.ownerAccount(model.ownerAccount);
            this.connectionId(model.connectionId);
            this.connectionName(model.connectionName);
            this.connectionState(model.connectionState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.vlan(model.vlan);
            this.partnerName(model.partnerName);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.awsDeviceV2(model.awsDeviceV2);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getPartnerName() {
            return this.partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public CreateConnectionResponse build() {
            return new CreateConnectionResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, CreateConnectionResponse> {
        public Builder ownerAccount(String var1);

        public Builder connectionId(String var1);

        public Builder connectionName(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder vlan(Integer var1);

        public Builder partnerName(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder awsDeviceV2(String var1);
    }
}

