/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Interconnect;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InterconnectMarshaller {
    private static final MarshallingInfo<String> INTERCONNECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectId").isBinary(false).build();
    private static final MarshallingInfo<String> INTERCONNECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectName").isBinary(false).build();
    private static final MarshallingInfo<String> INTERCONNECTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectState").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").isBinary(false).build();
    private static final MarshallingInfo<Instant> LOAISSUETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaIssueTime").isBinary(false).build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").isBinary(false).build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").isBinary(false).build();
    private static final InterconnectMarshaller INSTANCE = new InterconnectMarshaller();

    private InterconnectMarshaller() {
    }

    public static InterconnectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Interconnect interconnect, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)interconnect, (String)"interconnect");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)interconnect.interconnectId(), INTERCONNECTID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.interconnectName(), INTERCONNECTNAME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.interconnectStateAsString(), INTERCONNECTSTATE_BINDING);
            protocolMarshaller.marshall((Object)interconnect.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.bandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)interconnect.loaIssueTime(), LOAISSUETIME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.lagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.awsDevice(), AWSDEVICE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

