/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionLoaRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeConnectionLoaRequestModelMarshaller {
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerName").isBinary(false).build();
    private static final MarshallingInfo<String> LOACONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContentType").isBinary(false).build();
    private static final DescribeConnectionLoaRequestModelMarshaller INSTANCE = new DescribeConnectionLoaRequestModelMarshaller();

    private DescribeConnectionLoaRequestModelMarshaller() {
    }

    public static DescribeConnectionLoaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeConnectionLoaRequest describeConnectionLoaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeConnectionLoaRequest), (String)"describeConnectionLoaRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeConnectionLoaRequest.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)describeConnectionLoaRequest.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)describeConnectionLoaRequest.loaContentTypeAsString(), LOACONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

