/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.transform.NewBGPPeerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewBGPPeer
implements StructuredPojo,
ToCopyableBuilder<Builder, NewBGPPeer> {
    private final Integer asn;
    private final String authKey;
    private final String addressFamily;
    private final String amazonAddress;
    private final String customerAddress;

    private NewBGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyAsString() {
        return this.addressFamily;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewBGPPeer)) {
            return false;
        }
        NewBGPPeer other = (NewBGPPeer)obj;
        return Objects.equals(this.asn(), other.asn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress());
    }

    public String toString() {
        return ToString.builder((String)"NewBGPPeer").add("Asn", (Object)this.asn()).add("AuthKey", (Object)this.authKey()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewBGPPeerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer asn;
        private String authKey;
        private String addressFamily;
        private String amazonAddress;
        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NewBGPPeer model) {
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.addressFamily(model.addressFamily);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public NewBGPPeer build() {
            return new NewBGPPeer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NewBGPPeer> {
        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);
    }
}

