/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.ResourceTag;
import software.amazon.awssdk.services.directconnect.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTagsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<ResourceTag> resourceTags;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTags = builder.resourceTags;
    }

    public List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("ResourceTags", this.resourceTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.resourceTags(model.resourceTags);
        }

        public final Collection<ResourceTag.Builder> getResourceTags() {
            return this.resourceTags != null ? (Collection)this.resourceTags.stream().map(ResourceTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);
    }
}

