/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocatePrivateVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocatePrivateVirtualInterfaceRequest> {
    private final String connectionId;
    private final String ownerAccount;
    private final NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

    private AllocatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPrivateVirtualInterfaceAllocation = builder.newPrivateVirtualInterfaceAllocation;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation() {
        return this.newPrivateVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPrivateVirtualInterfaceAllocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePrivateVirtualInterfaceRequest other = (AllocatePrivateVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.newPrivateVirtualInterfaceAllocation(), other.newPrivateVirtualInterfaceAllocation());
    }

    public String toString() {
        return ToString.builder((String)"AllocatePrivateVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("NewPrivateVirtualInterfaceAllocation", (Object)this.newPrivateVirtualInterfaceAllocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "newPrivateVirtualInterfaceAllocation": {
                return Optional.ofNullable(clazz.cast(this.newPrivateVirtualInterfaceAllocation()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePrivateVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.newPrivateVirtualInterfaceAllocation(model.newPrivateVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final NewPrivateVirtualInterfaceAllocation.Builder getNewPrivateVirtualInterfaceAllocation() {
            return this.newPrivateVirtualInterfaceAllocation != null ? this.newPrivateVirtualInterfaceAllocation.toBuilder() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation;
            return this;
        }

        public final void setNewPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation.BuilderImpl newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation != null ? newPrivateVirtualInterfaceAllocation.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocatePrivateVirtualInterfaceRequest build() {
            return new AllocatePrivateVirtualInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, AllocatePrivateVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation var1);

        default public Builder newPrivateVirtualInterfaceAllocation(Consumer<NewPrivateVirtualInterfaceAllocation.Builder> newPrivateVirtualInterfaceAllocation) {
            return this.newPrivateVirtualInterfaceAllocation((NewPrivateVirtualInterfaceAllocation)((NewPrivateVirtualInterfaceAllocation.Builder)NewPrivateVirtualInterfaceAllocation.builder().applyMutation(newPrivateVirtualInterfaceAllocation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

