/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Loa;

@SdkInternalApi
public class LoaMarshaller {
    private static final MarshallingInfo<ByteBuffer> LOACONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContent").build();
    private static final MarshallingInfo<String> LOACONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContentType").build();
    private static final LoaMarshaller instance = new LoaMarshaller();

    public static LoaMarshaller getInstance() {
        return instance;
    }

    public void marshall(Loa loa, ProtocolMarshaller protocolMarshaller) {
        if (loa == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)loa.loaContent(), LOACONTENT_BINDING);
            protocolMarshaller.marshall((Object)loa.loaContentType(), LOACONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

