/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Interconnect;

@SdkInternalApi
public class InterconnectMarshaller {
    private static final MarshallingInfo<String> INTERCONNECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectId").build();
    private static final MarshallingInfo<String> INTERCONNECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectName").build();
    private static final MarshallingInfo<String> INTERCONNECTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectState").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").build();
    private static final MarshallingInfo<Date> LOAISSUETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaIssueTime").build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").build();
    private static final InterconnectMarshaller instance = new InterconnectMarshaller();

    public static InterconnectMarshaller getInstance() {
        return instance;
    }

    public void marshall(Interconnect interconnect, ProtocolMarshaller protocolMarshaller) {
        if (interconnect == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)interconnect.interconnectId(), INTERCONNECTID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.interconnectName(), INTERCONNECTNAME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.interconnectState(), INTERCONNECTSTATE_BINDING);
            protocolMarshaller.marshall((Object)interconnect.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.bandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)interconnect.loaIssueTime(), LOAISSUETIME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.lagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.awsDevice(), AWSDEVICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

