/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeerState;
import software.amazon.awssdk.services.directconnect.model.BGPStatus;
import software.amazon.awssdk.services.directconnect.transform.BGPPeerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BGPPeer
implements StructuredPojo,
ToCopyableBuilder<Builder, BGPPeer> {
    private final Integer asn;
    private final String authKey;
    private final String addressFamily;
    private final String amazonAddress;
    private final String customerAddress;
    private final String bgpPeerState;
    private final String bgpStatus;

    private BGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerState = builder.bgpPeerState;
        this.bgpStatus = builder.bgpStatus;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String addressFamily() {
        return this.addressFamily;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public String bgpPeerState() {
        return this.bgpPeerState;
    }

    public String bgpStatus() {
        return this.bgpStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.asn() == null ? 0 : this.asn().hashCode());
        hashCode = 31 * hashCode + (this.authKey() == null ? 0 : this.authKey().hashCode());
        hashCode = 31 * hashCode + (this.addressFamily() == null ? 0 : this.addressFamily().hashCode());
        hashCode = 31 * hashCode + (this.amazonAddress() == null ? 0 : this.amazonAddress().hashCode());
        hashCode = 31 * hashCode + (this.customerAddress() == null ? 0 : this.customerAddress().hashCode());
        hashCode = 31 * hashCode + (this.bgpPeerState() == null ? 0 : this.bgpPeerState().hashCode());
        hashCode = 31 * hashCode + (this.bgpStatus() == null ? 0 : this.bgpStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BGPPeer)) {
            return false;
        }
        BGPPeer other = (BGPPeer)obj;
        if (other.asn() == null ^ this.asn() == null) {
            return false;
        }
        if (other.asn() != null && !other.asn().equals(this.asn())) {
            return false;
        }
        if (other.authKey() == null ^ this.authKey() == null) {
            return false;
        }
        if (other.authKey() != null && !other.authKey().equals(this.authKey())) {
            return false;
        }
        if (other.addressFamily() == null ^ this.addressFamily() == null) {
            return false;
        }
        if (other.addressFamily() != null && !other.addressFamily().equals(this.addressFamily())) {
            return false;
        }
        if (other.amazonAddress() == null ^ this.amazonAddress() == null) {
            return false;
        }
        if (other.amazonAddress() != null && !other.amazonAddress().equals(this.amazonAddress())) {
            return false;
        }
        if (other.customerAddress() == null ^ this.customerAddress() == null) {
            return false;
        }
        if (other.customerAddress() != null && !other.customerAddress().equals(this.customerAddress())) {
            return false;
        }
        if (other.bgpPeerState() == null ^ this.bgpPeerState() == null) {
            return false;
        }
        if (other.bgpPeerState() != null && !other.bgpPeerState().equals(this.bgpPeerState())) {
            return false;
        }
        if (other.bgpStatus() == null ^ this.bgpStatus() == null) {
            return false;
        }
        return other.bgpStatus() == null || other.bgpStatus().equals(this.bgpStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.authKey() != null) {
            sb.append("AuthKey: ").append(this.authKey()).append(",");
        }
        if (this.addressFamily() != null) {
            sb.append("AddressFamily: ").append(this.addressFamily()).append(",");
        }
        if (this.amazonAddress() != null) {
            sb.append("AmazonAddress: ").append(this.amazonAddress()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        if (this.bgpPeerState() != null) {
            sb.append("BgpPeerState: ").append(this.bgpPeerState()).append(",");
        }
        if (this.bgpStatus() != null) {
            sb.append("BgpStatus: ").append(this.bgpStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BGPPeerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer asn;
        private String authKey;
        private String addressFamily;
        private String amazonAddress;
        private String customerAddress;
        private String bgpPeerState;
        private String bgpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BGPPeer model) {
            this.setAsn(model.asn);
            this.setAuthKey(model.authKey);
            this.setAddressFamily(model.addressFamily);
            this.setAmazonAddress(model.amazonAddress);
            this.setCustomerAddress(model.customerAddress);
            this.setBgpPeerState(model.bgpPeerState);
            this.setBgpStatus(model.bgpStatus);
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final void setAddressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getBgpPeerState() {
            return this.bgpPeerState;
        }

        @Override
        public final Builder bgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
            return this;
        }

        @Override
        public final Builder bgpPeerState(BGPPeerState bgpPeerState) {
            this.bgpPeerState(bgpPeerState.toString());
            return this;
        }

        public final void setBgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
        }

        public final void setBgpPeerState(BGPPeerState bgpPeerState) {
            this.bgpPeerState(bgpPeerState.toString());
        }

        public final String getBgpStatus() {
            return this.bgpStatus;
        }

        @Override
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        public final Builder bgpStatus(BGPStatus bgpStatus) {
            this.bgpStatus(bgpStatus.toString());
            return this;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        public final void setBgpStatus(BGPStatus bgpStatus) {
            this.bgpStatus(bgpStatus.toString());
        }

        public BGPPeer build() {
            return new BGPPeer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BGPPeer> {
        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder bgpPeerState(String var1);

        public Builder bgpPeerState(BGPPeerState var1);

        public Builder bgpStatus(String var1);

        public Builder bgpStatus(BGPStatus var1);
    }
}

