/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about updating the integration status of an Amazon Web Services service, such as Amazon Web Services
 * Systems Manager, with DevOps Guru.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceIntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateServiceIntegrationConfig.Builder, UpdateServiceIntegrationConfig> {
    private static final SdkField<OpsCenterIntegrationConfig> OPS_CENTER_FIELD = SdkField
            .<OpsCenterIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("OpsCenter")
            .getter(getter(UpdateServiceIntegrationConfig::opsCenter)).setter(setter(Builder::opsCenter))
            .constructor(OpsCenterIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenter").build()).build();

    private static final SdkField<LogsAnomalyDetectionIntegrationConfig> LOGS_ANOMALY_DETECTION_FIELD = SdkField
            .<LogsAnomalyDetectionIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("LogsAnomalyDetection")
            .getter(getter(UpdateServiceIntegrationConfig::logsAnomalyDetection)).setter(setter(Builder::logsAnomalyDetection))
            .constructor(LogsAnomalyDetectionIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsAnomalyDetection").build())
            .build();

    private static final SdkField<KMSServerSideEncryptionIntegrationConfig> KMS_SERVER_SIDE_ENCRYPTION_FIELD = SdkField
            .<KMSServerSideEncryptionIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("KMSServerSideEncryption")
            .getter(getter(UpdateServiceIntegrationConfig::kmsServerSideEncryption))
            .setter(setter(Builder::kmsServerSideEncryption)).constructor(KMSServerSideEncryptionIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSServerSideEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_CENTER_FIELD,
            LOGS_ANOMALY_DETECTION_FIELD, KMS_SERVER_SIDE_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpsCenterIntegrationConfig opsCenter;

    private final LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection;

    private final KMSServerSideEncryptionIntegrationConfig kmsServerSideEncryption;

    private UpdateServiceIntegrationConfig(BuilderImpl builder) {
        this.opsCenter = builder.opsCenter;
        this.logsAnomalyDetection = builder.logsAnomalyDetection;
        this.kmsServerSideEncryption = builder.kmsServerSideEncryption;
    }

    /**
     * Returns the value of the OpsCenter property for this object.
     * 
     * @return The value of the OpsCenter property for this object.
     */
    public final OpsCenterIntegrationConfig opsCenter() {
        return opsCenter;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
     * groups.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch
     *         log groups.
     */
    public final LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection() {
        return logsAnomalyDetection;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
     */
    public final KMSServerSideEncryptionIntegrationConfig kmsServerSideEncryption() {
        return kmsServerSideEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsCenter());
        hashCode = 31 * hashCode + Objects.hashCode(logsAnomalyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(kmsServerSideEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceIntegrationConfig)) {
            return false;
        }
        UpdateServiceIntegrationConfig other = (UpdateServiceIntegrationConfig) obj;
        return Objects.equals(opsCenter(), other.opsCenter())
                && Objects.equals(logsAnomalyDetection(), other.logsAnomalyDetection())
                && Objects.equals(kmsServerSideEncryption(), other.kmsServerSideEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceIntegrationConfig").add("OpsCenter", opsCenter())
                .add("LogsAnomalyDetection", logsAnomalyDetection()).add("KMSServerSideEncryption", kmsServerSideEncryption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsCenter":
            return Optional.ofNullable(clazz.cast(opsCenter()));
        case "LogsAnomalyDetection":
            return Optional.ofNullable(clazz.cast(logsAnomalyDetection()));
        case "KMSServerSideEncryption":
            return Optional.ofNullable(clazz.cast(kmsServerSideEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpsCenter", OPS_CENTER_FIELD);
        map.put("LogsAnomalyDetection", LOGS_ANOMALY_DETECTION_FIELD);
        map.put("KMSServerSideEncryption", KMS_SERVER_SIDE_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceIntegrationConfig, T> g) {
        return obj -> g.apply((UpdateServiceIntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateServiceIntegrationConfig> {
        /**
         * Sets the value of the OpsCenter property for this object.
         *
         * @param opsCenter
         *        The new value for the OpsCenter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenter(OpsCenterIntegrationConfig opsCenter);

        /**
         * Sets the value of the OpsCenter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpsCenterIntegrationConfig.Builder}
         * avoiding the need to create one manually via {@link OpsCenterIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpsCenterIntegrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #opsCenter(OpsCenterIntegrationConfig)}.
         * 
         * @param opsCenter
         *        a consumer that will call methods on {@link OpsCenterIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsCenter(OpsCenterIntegrationConfig)
         */
        default Builder opsCenter(Consumer<OpsCenterIntegrationConfig.Builder> opsCenter) {
            return opsCenter(OpsCenterIntegrationConfig.builder().applyMutation(opsCenter).build());
        }

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * 
         * @param logsAnomalyDetection
         *        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon
         *        CloudWatch log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LogsAnomalyDetectionIntegrationConfig.Builder} avoiding the need to create one manually via
         * {@link LogsAnomalyDetectionIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsAnomalyDetectionIntegrationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig)}.
         * 
         * @param logsAnomalyDetection
         *        a consumer that will call methods on {@link LogsAnomalyDetectionIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig)
         */
        default Builder logsAnomalyDetection(Consumer<LogsAnomalyDetectionIntegrationConfig.Builder> logsAnomalyDetection) {
            return logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig.builder().applyMutation(logsAnomalyDetection)
                    .build());
        }

        /**
         * <p>
         * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * </p>
         * 
         * @param kmsServerSideEncryption
         *        Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig kmsServerSideEncryption);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KMSServerSideEncryptionIntegrationConfig.Builder} avoiding the need to create one manually via
         * {@link KMSServerSideEncryptionIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KMSServerSideEncryptionIntegrationConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig)}.
         * 
         * @param kmsServerSideEncryption
         *        a consumer that will call methods on {@link KMSServerSideEncryptionIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig)
         */
        default Builder kmsServerSideEncryption(Consumer<KMSServerSideEncryptionIntegrationConfig.Builder> kmsServerSideEncryption) {
            return kmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig.builder()
                    .applyMutation(kmsServerSideEncryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpsCenterIntegrationConfig opsCenter;

        private LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection;

        private KMSServerSideEncryptionIntegrationConfig kmsServerSideEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceIntegrationConfig model) {
            opsCenter(model.opsCenter);
            logsAnomalyDetection(model.logsAnomalyDetection);
            kmsServerSideEncryption(model.kmsServerSideEncryption);
        }

        public final OpsCenterIntegrationConfig.Builder getOpsCenter() {
            return opsCenter != null ? opsCenter.toBuilder() : null;
        }

        public final void setOpsCenter(OpsCenterIntegrationConfig.BuilderImpl opsCenter) {
            this.opsCenter = opsCenter != null ? opsCenter.build() : null;
        }

        @Override
        public final Builder opsCenter(OpsCenterIntegrationConfig opsCenter) {
            this.opsCenter = opsCenter;
            return this;
        }

        public final LogsAnomalyDetectionIntegrationConfig.Builder getLogsAnomalyDetection() {
            return logsAnomalyDetection != null ? logsAnomalyDetection.toBuilder() : null;
        }

        public final void setLogsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig.BuilderImpl logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection != null ? logsAnomalyDetection.build() : null;
        }

        @Override
        public final Builder logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection;
            return this;
        }

        public final KMSServerSideEncryptionIntegrationConfig.Builder getKmsServerSideEncryption() {
            return kmsServerSideEncryption != null ? kmsServerSideEncryption.toBuilder() : null;
        }

        public final void setKmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig.BuilderImpl kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption != null ? kmsServerSideEncryption.build() : null;
        }

        @Override
        public final Builder kmsServerSideEncryption(KMSServerSideEncryptionIntegrationConfig kmsServerSideEncryption) {
            this.kmsServerSideEncryption = kmsServerSideEncryption;
            return this;
        }

        @Override
        public UpdateServiceIntegrationConfig build() {
            return new UpdateServiceIntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
