/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceCollectionRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<UpdateResourceCollectionRequest.Builder, UpdateResourceCollectionRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(UpdateResourceCollectionRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<UpdateResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField
            .<UpdateResourceCollectionFilter> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(UpdateResourceCollectionRequest::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(UpdateResourceCollectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            RESOURCE_COLLECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final UpdateResourceCollectionFilter resourceCollection;

    private UpdateResourceCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.resourceCollection = builder.resourceCollection;
    }

    /**
     * <p>
     * Specifies if the resource collection in the request is added or deleted to the resource collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateResourceCollectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies if the resource collection in the request is added or deleted to the resource collection.
     * @see UpdateResourceCollectionAction
     */
    public final UpdateResourceCollectionAction action() {
        return UpdateResourceCollectionAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies if the resource collection in the request is added or deleted to the resource collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateResourceCollectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies if the resource collection in the request is added or deleted to the resource collection.
     * @see UpdateResourceCollectionAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final UpdateResourceCollectionFilter resourceCollection() {
        return resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceCollectionRequest)) {
            return false;
        }
        UpdateResourceCollectionRequest other = (UpdateResourceCollectionRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(resourceCollection(), other.resourceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceCollectionRequest").add("Action", actionAsString())
                .add("ResourceCollection", resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceCollectionRequest, T> g) {
        return obj -> g.apply((UpdateResourceCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResourceCollectionRequest> {
        /**
         * <p>
         * Specifies if the resource collection in the request is added or deleted to the resource collection.
         * </p>
         * 
         * @param action
         *        Specifies if the resource collection in the request is added or deleted to the resource collection.
         * @see UpdateResourceCollectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateResourceCollectionAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies if the resource collection in the request is added or deleted to the resource collection.
         * </p>
         * 
         * @param action
         *        Specifies if the resource collection in the request is added or deleted to the resource collection.
         * @see UpdateResourceCollectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateResourceCollectionAction
         */
        Builder action(UpdateResourceCollectionAction action);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(UpdateResourceCollectionFilter resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UpdateResourceCollectionFilter.Builder}
         * avoiding the need to create one manually via {@link UpdateResourceCollectionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateResourceCollectionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCollection(UpdateResourceCollectionFilter)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link UpdateResourceCollectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(UpdateResourceCollectionFilter)
         */
        default Builder resourceCollection(Consumer<UpdateResourceCollectionFilter.Builder> resourceCollection) {
            return resourceCollection(UpdateResourceCollectionFilter.builder().applyMutation(resourceCollection).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private String action;

        private UpdateResourceCollectionFilter resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceCollectionRequest model) {
            super(model);
            action(model.action);
            resourceCollection(model.resourceCollection);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateResourceCollectionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final UpdateResourceCollectionFilter.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(UpdateResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(UpdateResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceCollectionRequest build() {
            return new UpdateResourceCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
