/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web
 * Services tag <i>key</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagHealth implements SdkPojo, Serializable, ToCopyableBuilder<TagHealth.Builder, TagHealth> {
    private static final SdkField<String> APP_BOUNDARY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBoundaryKey").getter(getter(TagHealth::appBoundaryKey)).setter(setter(Builder::appBoundaryKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBoundaryKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagValue").getter(getter(TagHealth::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()).build();

    private static final SdkField<InsightHealth> INSIGHT_FIELD = SdkField.<InsightHealth> builder(MarshallingType.SDK_POJO)
            .memberName("Insight").getter(getter(TagHealth::insight)).setter(setter(Builder::insight))
            .constructor(InsightHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()).build();

    private static final SdkField<Long> ANALYZED_RESOURCE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AnalyzedResourceCount").getter(getter(TagHealth::analyzedResourceCount))
            .setter(setter(Builder::analyzedResourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedResourceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BOUNDARY_KEY_FIELD,
            TAG_VALUE_FIELD, INSIGHT_FIELD, ANALYZED_RESOURCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appBoundaryKey;

    private final String tagValue;

    private final InsightHealth insight;

    private final Long analyzedResourceCount;

    private TagHealth(BuilderImpl builder) {
        this.appBoundaryKey = builder.appBoundaryKey;
        this.tagValue = builder.tagValue;
        this.insight = builder.insight;
        this.analyzedResourceCount = builder.analyzedResourceCount;
    }

    /**
     * <p>
     * An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru
     * analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your
     * DevOps Guru application and analysis boundary.
     * </p>
     * <important>
     * <p>
     * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
     * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code> or
     * <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the <i>key</i>
     * can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works
     * with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and
     * these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     * <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>
     * .
     * </p>
     * </important>
     * 
     * @return An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that
     *         DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this
     *         <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
     *         <p>
     *         The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with
     *         the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
     *         <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
     *         create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
     *         create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
     *         <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
     *         different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     *         <code>Devops-Guru-production-application/RDS</code> or
     *         <code>Devops-Guru-production-application/containers</code>.
     *         </p>
     */
    public final String appBoundaryKey() {
        return appBoundaryKey;
    }

    /**
     * <p>
     * The value in an Amazon Web Services tag.
     * </p>
     * <p>
     * The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example,
     * <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the
     * tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>,
     * tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     * </p>
     * 
     * @return The value in an Amazon Web Services tag.</p>
     *         <p>
     *         The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for
     *         example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and
     *         <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty
     *         string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256
     *         characters for a tag value.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * <p>
     * Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon
     * Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover
     * (MTTR) of closed insights.
     * </p>
     * 
     * @return Information about the health of the Amazon Web Services resources in your account that are specified by
     *         an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean
     *         Time to Recover (MTTR) of closed insights.
     */
    public final InsightHealth insight() {
        return insight;
    }

    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web Services
     * tag.
     * </p>
     * 
     * @return Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web
     *         Services tag.
     */
    public final Long analyzedResourceCount() {
        return analyzedResourceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appBoundaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(insight());
        hashCode = 31 * hashCode + Objects.hashCode(analyzedResourceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagHealth)) {
            return false;
        }
        TagHealth other = (TagHealth) obj;
        return Objects.equals(appBoundaryKey(), other.appBoundaryKey()) && Objects.equals(tagValue(), other.tagValue())
                && Objects.equals(insight(), other.insight())
                && Objects.equals(analyzedResourceCount(), other.analyzedResourceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagHealth").add("AppBoundaryKey", appBoundaryKey()).add("TagValue", tagValue())
                .add("Insight", insight()).add("AnalyzedResourceCount", analyzedResourceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBoundaryKey":
            return Optional.ofNullable(clazz.cast(appBoundaryKey()));
        case "TagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "Insight":
            return Optional.ofNullable(clazz.cast(insight()));
        case "AnalyzedResourceCount":
            return Optional.ofNullable(clazz.cast(analyzedResourceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppBoundaryKey", APP_BOUNDARY_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        map.put("AnalyzedResourceCount", ANALYZED_RESOURCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagHealth, T> g) {
        return obj -> g.apply((TagHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagHealth> {
        /**
         * <p>
         * An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps
         * Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make
         * up your DevOps Guru application and analysis boundary.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param appBoundaryKey
         *        An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that
         *        DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this
         *        <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBoundaryKey(String appBoundaryKey);

        /**
         * <p>
         * The value in an Amazon Web Services tag.
         * </p>
         * <p>
         * The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example,
         * <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the
         * tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag
         * <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag
         * value.
         * </p>
         * 
         * @param tagValue
         *        The value in an Amazon Web Services tag.</p>
         *        <p>
         *        The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for
         *        example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and
         *        <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an
         *        empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of
         *        256 characters for a tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * <p>
         * Information about the health of the Amazon Web Services resources in your account that are specified by an
         * Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to
         * Recover (MTTR) of closed insights.
         * </p>
         * 
         * @param insight
         *        Information about the health of the Amazon Web Services resources in your account that are specified
         *        by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the
         *        Mean Time to Recover (MTTR) of closed insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insight(InsightHealth insight);

        /**
         * <p>
         * Information about the health of the Amazon Web Services resources in your account that are specified by an
         * Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to
         * Recover (MTTR) of closed insights.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightHealth.Builder} avoiding the need
         * to create one manually via {@link InsightHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #insight(InsightHealth)}.
         * 
         * @param insight
         *        a consumer that will call methods on {@link InsightHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insight(InsightHealth)
         */
        default Builder insight(Consumer<InsightHealth.Builder> insight) {
            return insight(InsightHealth.builder().applyMutation(insight).build());
        }

        /**
         * <p>
         * Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web
         * Services tag.
         * </p>
         * 
         * @param analyzedResourceCount
         *        Number of resources that DevOps Guru is monitoring in your account that are specified by an Amazon Web
         *        Services tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedResourceCount(Long analyzedResourceCount);
    }

    static final class BuilderImpl implements Builder {
        private String appBoundaryKey;

        private String tagValue;

        private InsightHealth insight;

        private Long analyzedResourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TagHealth model) {
            appBoundaryKey(model.appBoundaryKey);
            tagValue(model.tagValue);
            insight(model.insight);
            analyzedResourceCount(model.analyzedResourceCount);
        }

        public final String getAppBoundaryKey() {
            return appBoundaryKey;
        }

        public final void setAppBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
        }

        @Override
        public final Builder appBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final InsightHealth.Builder getInsight() {
            return insight != null ? insight.toBuilder() : null;
        }

        public final void setInsight(InsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(InsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public final Long getAnalyzedResourceCount() {
            return analyzedResourceCount;
        }

        public final void setAnalyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
        }

        @Override
        public final Builder analyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
            return this;
        }

        @Override
        public TagHealth build() {
            return new TagHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
