/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of Amazon Web Services tags used to filter insights. This is used to return insights generated from only
 * resources that contain the tags in the tag collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagCollectionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TagCollectionFilter.Builder, TagCollectionFilter> {
    private static final SdkField<String> APP_BOUNDARY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBoundaryKey").getter(getter(TagCollectionFilter::appBoundaryKey))
            .setter(setter(Builder::appBoundaryKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBoundaryKey").build()).build();

    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValues")
            .getter(getter(TagCollectionFilter::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BOUNDARY_KEY_FIELD,
            TAG_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appBoundaryKey;

    private final List<String> tagValues;

    private TagCollectionFilter(BuilderImpl builder) {
        this.appBoundaryKey = builder.appBoundaryKey;
        this.tagValues = builder.tagValues;
    }

    /**
     * <p>
     * An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru
     * analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your
     * DevOps Guru application and analysis boundary.
     * </p>
     * <important>
     * <p>
     * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
     * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code> or
     * <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the <i>key</i>
     * can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works
     * with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and
     * these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     * <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>
     * .
     * </p>
     * </important>
     * 
     * @return An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that
     *         DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this
     *         <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
     *         <p>
     *         The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with
     *         the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
     *         <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
     *         create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
     *         create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
     *         <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
     *         different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     *         <code>Devops-Guru-production-application/RDS</code> or
     *         <code>Devops-Guru-production-application/containers</code>.
     *         </p>
     */
    public final String appBoundaryKey() {
        return appBoundaryKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values in an Amazon Web Services tag collection.
     * </p>
     * <p>
     * The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example,
     * <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the
     * tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>,
     * tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return The values in an Amazon Web Services tag collection.</p>
     *         <p>
     *         The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for
     *         example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and
     *         <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty
     *         string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256
     *         characters for a tag value.
     */
    public final List<String> tagValues() {
        return tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appBoundaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagCollectionFilter)) {
            return false;
        }
        TagCollectionFilter other = (TagCollectionFilter) obj;
        return Objects.equals(appBoundaryKey(), other.appBoundaryKey()) && hasTagValues() == other.hasTagValues()
                && Objects.equals(tagValues(), other.tagValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagCollectionFilter").add("AppBoundaryKey", appBoundaryKey())
                .add("TagValues", hasTagValues() ? tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBoundaryKey":
            return Optional.ofNullable(clazz.cast(appBoundaryKey()));
        case "TagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppBoundaryKey", APP_BOUNDARY_KEY_FIELD);
        map.put("TagValues", TAG_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagCollectionFilter, T> g) {
        return obj -> g.apply((TagCollectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagCollectionFilter> {
        /**
         * <p>
         * An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps
         * Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make
         * up your DevOps Guru application and analysis boundary.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param appBoundaryKey
         *        An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that
         *        DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this
         *        <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBoundaryKey(String appBoundaryKey);

        /**
         * <p>
         * The values in an Amazon Web Services tag collection.
         * </p>
         * <p>
         * The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example,
         * <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the
         * tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag
         * <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag
         * value.
         * </p>
         * 
         * @param tagValues
         *        The values in an Amazon Web Services tag collection.</p>
         *        <p>
         *        The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for
         *        example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and
         *        <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an
         *        empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of
         *        256 characters for a tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<String> tagValues);

        /**
         * <p>
         * The values in an Amazon Web Services tag collection.
         * </p>
         * <p>
         * The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example,
         * <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the
         * tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag
         * <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag
         * value.
         * </p>
         * 
         * @param tagValues
         *        The values in an Amazon Web Services tag collection.</p>
         *        <p>
         *        The tag's <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for
         *        example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and
         *        <i>value</i> are the tag's <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an
         *        empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of
         *        256 characters for a tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(String... tagValues);
    }

    static final class BuilderImpl implements Builder {
        private String appBoundaryKey;

        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagCollectionFilter model) {
            appBoundaryKey(model.appBoundaryKey);
            tagValues(model.tagValues);
        }

        public final String getAppBoundaryKey() {
            return appBoundaryKey;
        }

        public final void setAppBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
        }

        @Override
        public final Builder appBoundaryKey(String appBoundaryKey) {
            this.appBoundaryKey = appBoundaryKey;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        public TagCollectionFilter build() {
            return new TagCollectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
