/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the health of an Amazon Web Services service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceHealth implements SdkPojo, Serializable, ToCopyableBuilder<ServiceHealth.Builder, ServiceHealth> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceHealth::serviceNameAsString)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<ServiceInsightHealth> INSIGHT_FIELD = SdkField
            .<ServiceInsightHealth> builder(MarshallingType.SDK_POJO).memberName("Insight")
            .getter(getter(ServiceHealth::insight)).setter(setter(Builder::insight)).constructor(ServiceInsightHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()).build();

    private static final SdkField<Long> ANALYZED_RESOURCE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AnalyzedResourceCount").getter(getter(ServiceHealth::analyzedResourceCount))
            .setter(setter(Builder::analyzedResourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedResourceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            INSIGHT_FIELD, ANALYZED_RESOURCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final ServiceInsightHealth insight;

    private final Long analyzedResourceCount;

    private ServiceHealth(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.insight = builder.insight;
        this.analyzedResourceCount = builder.analyzedResourceCount;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service.
     * @see ServiceName
     */
    public final ServiceName serviceName() {
        return ServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service.
     * @see ServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * <p>
     * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     * contains the number of open proactive and reactive insights for this service.
     * </p>
     * 
     * @return Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     *         contains the number of open proactive and reactive insights for this service.
     */
    public final ServiceInsightHealth insight() {
        return insight;
    }

    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * </p>
     * 
     * @return Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     */
    public final Long analyzedResourceCount() {
        return analyzedResourceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(insight());
        hashCode = 31 * hashCode + Objects.hashCode(analyzedResourceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceHealth)) {
            return false;
        }
        ServiceHealth other = (ServiceHealth) obj;
        return Objects.equals(serviceNameAsString(), other.serviceNameAsString()) && Objects.equals(insight(), other.insight())
                && Objects.equals(analyzedResourceCount(), other.analyzedResourceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceHealth").add("ServiceName", serviceNameAsString()).add("Insight", insight())
                .add("AnalyzedResourceCount", analyzedResourceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "Insight":
            return Optional.ofNullable(clazz.cast(insight()));
        case "AnalyzedResourceCount":
            return Optional.ofNullable(clazz.cast(analyzedResourceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        map.put("AnalyzedResourceCount", ANALYZED_RESOURCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceHealth, T> g) {
        return obj -> g.apply((ServiceHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceHealth> {
        /**
         * <p>
         * The name of the Amazon Web Services service.
         * </p>
         * 
         * @param serviceName
         *        The name of the Amazon Web Services service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the Amazon Web Services service.
         * </p>
         * 
         * @param serviceName
         *        The name of the Amazon Web Services service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(ServiceName serviceName);

        /**
         * <p>
         * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
         * contains the number of open proactive and reactive insights for this service.
         * </p>
         * 
         * @param insight
         *        Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code>
         *        that contains the number of open proactive and reactive insights for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insight(ServiceInsightHealth insight);

        /**
         * <p>
         * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
         * contains the number of open proactive and reactive insights for this service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceInsightHealth.Builder} avoiding
         * the need to create one manually via {@link ServiceInsightHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceInsightHealth.Builder#build()} is called immediately and
         * its result is passed to {@link #insight(ServiceInsightHealth)}.
         * 
         * @param insight
         *        a consumer that will call methods on {@link ServiceInsightHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insight(ServiceInsightHealth)
         */
        default Builder insight(Consumer<ServiceInsightHealth.Builder> insight) {
            return insight(ServiceInsightHealth.builder().applyMutation(insight).build());
        }

        /**
         * <p>
         * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
         * </p>
         * 
         * @param analyzedResourceCount
         *        Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedResourceCount(Long analyzedResourceCount);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private ServiceInsightHealth insight;

        private Long analyzedResourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceHealth model) {
            serviceName(model.serviceName);
            insight(model.insight);
            analyzedResourceCount(model.analyzedResourceCount);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final ServiceInsightHealth.Builder getInsight() {
            return insight != null ? insight.toBuilder() : null;
        }

        public final void setInsight(ServiceInsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(ServiceInsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public final Long getAnalyzedResourceCount() {
            return analyzedResourceCount;
        }

        public final void setAnalyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
        }

        @Override
        public final Builder analyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
            return this;
        }

        @Override
        public ServiceHealth build() {
            return new ServiceHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
