/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<PutFeedbackRequest.Builder, PutFeedbackRequest> {
    private static final SdkField<InsightFeedback> INSIGHT_FEEDBACK_FIELD = SdkField
            .<InsightFeedback> builder(MarshallingType.SDK_POJO).memberName("InsightFeedback")
            .getter(getter(PutFeedbackRequest::insightFeedback)).setter(setter(Builder::insightFeedback))
            .constructor(InsightFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InsightFeedback insightFeedback;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.insightFeedback = builder.insightFeedback;
    }

    /**
     * <p>
     * The feedback from customers is about the recommendations in this insight.
     * </p>
     * 
     * @return The feedback from customers is about the recommendations in this insight.
     */
    public final InsightFeedback insightFeedback() {
        return insightFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest) obj;
        return Objects.equals(insightFeedback(), other.insightFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackRequest").add("InsightFeedback", insightFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightFeedback":
            return Optional.ofNullable(clazz.cast(insightFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightFeedback", INSIGHT_FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackRequest> {
        /**
         * <p>
         * The feedback from customers is about the recommendations in this insight.
         * </p>
         * 
         * @param insightFeedback
         *        The feedback from customers is about the recommendations in this insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightFeedback(InsightFeedback insightFeedback);

        /**
         * <p>
         * The feedback from customers is about the recommendations in this insight.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightFeedback.Builder} avoiding the
         * need to create one manually via {@link InsightFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightFeedback.Builder#build()} is called immediately and its
         * result is passed to {@link #insightFeedback(InsightFeedback)}.
         * 
         * @param insightFeedback
         *        a consumer that will call methods on {@link InsightFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightFeedback(InsightFeedback)
         */
        default Builder insightFeedback(Consumer<InsightFeedback.Builder> insightFeedback) {
            return insightFeedback(InsightFeedback.builder().applyMutation(insightFeedback).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private InsightFeedback insightFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            insightFeedback(model.insightFeedback);
        }

        public final InsightFeedback.Builder getInsightFeedback() {
            return insightFeedback != null ? insightFeedback.toBuilder() : null;
        }

        public final void setInsightFeedback(InsightFeedback.BuilderImpl insightFeedback) {
            this.insightFeedback = insightFeedback != null ? insightFeedback.build() : null;
        }

        @Override
        public final Builder insightFeedback(InsightFeedback insightFeedback) {
            this.insightFeedback = insightFeedback;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
