/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a reference metric used to evaluate Performance Insights.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceInsightsReferenceMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceInsightsReferenceMetric.Builder, PerformanceInsightsReferenceMetric> {
    private static final SdkField<PerformanceInsightsMetricQuery> METRIC_QUERY_FIELD = SdkField
            .<PerformanceInsightsMetricQuery> builder(MarshallingType.SDK_POJO).memberName("MetricQuery")
            .getter(getter(PerformanceInsightsReferenceMetric::metricQuery)).setter(setter(Builder::metricQuery))
            .constructor(PerformanceInsightsMetricQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PerformanceInsightsMetricQuery metricQuery;

    private PerformanceInsightsReferenceMetric(BuilderImpl builder) {
        this.metricQuery = builder.metricQuery;
    }

    /**
     * <p>
     * A query to be processed on the metric.
     * </p>
     * 
     * @return A query to be processed on the metric.
     */
    public final PerformanceInsightsMetricQuery metricQuery() {
        return metricQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsReferenceMetric)) {
            return false;
        }
        PerformanceInsightsReferenceMetric other = (PerformanceInsightsReferenceMetric) obj;
        return Objects.equals(metricQuery(), other.metricQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceInsightsReferenceMetric").add("MetricQuery", metricQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricQuery":
            return Optional.ofNullable(clazz.cast(metricQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricQuery", METRIC_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsReferenceMetric, T> g) {
        return obj -> g.apply((PerformanceInsightsReferenceMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceInsightsReferenceMetric> {
        /**
         * <p>
         * A query to be processed on the metric.
         * </p>
         * 
         * @param metricQuery
         *        A query to be processed on the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQuery(PerformanceInsightsMetricQuery metricQuery);

        /**
         * <p>
         * A query to be processed on the metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceInsightsMetricQuery.Builder}
         * avoiding the need to create one manually via {@link PerformanceInsightsMetricQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsMetricQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #metricQuery(PerformanceInsightsMetricQuery)}.
         * 
         * @param metricQuery
         *        a consumer that will call methods on {@link PerformanceInsightsMetricQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricQuery(PerformanceInsightsMetricQuery)
         */
        default Builder metricQuery(Consumer<PerformanceInsightsMetricQuery.Builder> metricQuery) {
            return metricQuery(PerformanceInsightsMetricQuery.builder().applyMutation(metricQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PerformanceInsightsMetricQuery metricQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsReferenceMetric model) {
            metricQuery(model.metricQuery);
        }

        public final PerformanceInsightsMetricQuery.Builder getMetricQuery() {
            return metricQuery != null ? metricQuery.toBuilder() : null;
        }

        public final void setMetricQuery(PerformanceInsightsMetricQuery.BuilderImpl metricQuery) {
            this.metricQuery = metricQuery != null ? metricQuery.build() : null;
        }

        @Override
        public final Builder metricQuery(PerformanceInsightsMetricQuery metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        @Override
        public PerformanceInsightsReferenceMetric build() {
            return new PerformanceInsightsReferenceMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
