/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationInsightsResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<ListOrganizationInsightsResponse.Builder, ListOrganizationInsightsResponse> {
    private static final SdkField<List<ProactiveOrganizationInsightSummary>> PROACTIVE_INSIGHTS_FIELD = SdkField
            .<List<ProactiveOrganizationInsightSummary>> builder(MarshallingType.LIST)
            .memberName("ProactiveInsights")
            .getter(getter(ListOrganizationInsightsResponse::proactiveInsights))
            .setter(setter(Builder::proactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProactiveOrganizationInsightSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProactiveOrganizationInsightSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReactiveOrganizationInsightSummary>> REACTIVE_INSIGHTS_FIELD = SdkField
            .<List<ReactiveOrganizationInsightSummary>> builder(MarshallingType.LIST)
            .memberName("ReactiveInsights")
            .getter(getter(ListOrganizationInsightsResponse::reactiveInsights))
            .setter(setter(Builder::reactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReactiveOrganizationInsightSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReactiveOrganizationInsightSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOrganizationInsightsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHTS_FIELD,
            REACTIVE_INSIGHTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProactiveOrganizationInsightSummary> proactiveInsights;

    private final List<ReactiveOrganizationInsightSummary> reactiveInsights;

    private final String nextToken;

    private ListOrganizationInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsights = builder.proactiveInsights;
        this.reactiveInsights = builder.reactiveInsights;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProactiveInsights property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProactiveInsights() {
        return proactiveInsights != null && !(proactiveInsights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProactiveInsights} method.
     * </p>
     * 
     * @return An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     */
    public final List<ProactiveOrganizationInsightSummary> proactiveInsights() {
        return proactiveInsights;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReactiveInsights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReactiveInsights() {
        return reactiveInsights != null && !(reactiveInsights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReactiveInsights} method.
     * </p>
     * 
     * @return An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     */
    public final List<ReactiveOrganizationInsightSummary> reactiveInsights() {
        return reactiveInsights;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProactiveInsights() ? proactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReactiveInsights() ? reactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationInsightsResponse)) {
            return false;
        }
        ListOrganizationInsightsResponse other = (ListOrganizationInsightsResponse) obj;
        return hasProactiveInsights() == other.hasProactiveInsights()
                && Objects.equals(proactiveInsights(), other.proactiveInsights())
                && hasReactiveInsights() == other.hasReactiveInsights()
                && Objects.equals(reactiveInsights(), other.reactiveInsights()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOrganizationInsightsResponse")
                .add("ProactiveInsights", hasProactiveInsights() ? proactiveInsights() : null)
                .add("ReactiveInsights", hasReactiveInsights() ? reactiveInsights() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProactiveInsights":
            return Optional.ofNullable(clazz.cast(proactiveInsights()));
        case "ReactiveInsights":
            return Optional.ofNullable(clazz.cast(reactiveInsights()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProactiveInsights", PROACTIVE_INSIGHTS_FIELD);
        map.put("ReactiveInsights", REACTIVE_INSIGHTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationInsightsResponse, T> g) {
        return obj -> g.apply((ListOrganizationInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationInsightsResponse> {
        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param proactiveInsights
         *        An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(Collection<ProactiveOrganizationInsightSummary> proactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param proactiveInsights
         *        An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(ProactiveOrganizationInsightSummary... proactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #proactiveInsights(List<ProactiveOrganizationInsightSummary>)}.
         * 
         * @param proactiveInsights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveInsights(java.util.Collection<ProactiveOrganizationInsightSummary>)
         */
        Builder proactiveInsights(Consumer<ProactiveOrganizationInsightSummary.Builder>... proactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param reactiveInsights
         *        An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(Collection<ReactiveOrganizationInsightSummary> reactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param reactiveInsights
         *        An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(ReactiveOrganizationInsightSummary... reactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #reactiveInsights(List<ReactiveOrganizationInsightSummary>)}.
         * 
         * @param reactiveInsights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ReactiveOrganizationInsightSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reactiveInsights(java.util.Collection<ReactiveOrganizationInsightSummary>)
         */
        Builder reactiveInsights(Consumer<ReactiveOrganizationInsightSummary.Builder>... reactiveInsights);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private List<ProactiveOrganizationInsightSummary> proactiveInsights = DefaultSdkAutoConstructList.getInstance();

        private List<ReactiveOrganizationInsightSummary> reactiveInsights = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationInsightsResponse model) {
            super(model);
            proactiveInsights(model.proactiveInsights);
            reactiveInsights(model.reactiveInsights);
            nextToken(model.nextToken);
        }

        public final List<ProactiveOrganizationInsightSummary.Builder> getProactiveInsights() {
            List<ProactiveOrganizationInsightSummary.Builder> result = ProactiveOrganizationInsightsCopier
                    .copyToBuilder(this.proactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProactiveInsights(Collection<ProactiveOrganizationInsightSummary.BuilderImpl> proactiveInsights) {
            this.proactiveInsights = ProactiveOrganizationInsightsCopier.copyFromBuilder(proactiveInsights);
        }

        @Override
        public final Builder proactiveInsights(Collection<ProactiveOrganizationInsightSummary> proactiveInsights) {
            this.proactiveInsights = ProactiveOrganizationInsightsCopier.copy(proactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(ProactiveOrganizationInsightSummary... proactiveInsights) {
            proactiveInsights(Arrays.asList(proactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(Consumer<ProactiveOrganizationInsightSummary.Builder>... proactiveInsights) {
            proactiveInsights(Stream.of(proactiveInsights)
                    .map(c -> ProactiveOrganizationInsightSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReactiveOrganizationInsightSummary.Builder> getReactiveInsights() {
            List<ReactiveOrganizationInsightSummary.Builder> result = ReactiveOrganizationInsightsCopier
                    .copyToBuilder(this.reactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactiveInsights(Collection<ReactiveOrganizationInsightSummary.BuilderImpl> reactiveInsights) {
            this.reactiveInsights = ReactiveOrganizationInsightsCopier.copyFromBuilder(reactiveInsights);
        }

        @Override
        public final Builder reactiveInsights(Collection<ReactiveOrganizationInsightSummary> reactiveInsights) {
            this.reactiveInsights = ReactiveOrganizationInsightsCopier.copy(reactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(ReactiveOrganizationInsightSummary... reactiveInsights) {
            reactiveInsights(Arrays.asList(reactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(Consumer<ReactiveOrganizationInsightSummary.Builder>... reactiveInsights) {
            reactiveInsights(Stream.of(reactiveInsights)
                    .map(c -> ReactiveOrganizationInsightSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationInsightsResponse build() {
            return new ListOrganizationInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
