/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<ListInsightsResponse.Builder, ListInsightsResponse> {
    private static final SdkField<List<ProactiveInsightSummary>> PROACTIVE_INSIGHTS_FIELD = SdkField
            .<List<ProactiveInsightSummary>> builder(MarshallingType.LIST)
            .memberName("ProactiveInsights")
            .getter(getter(ListInsightsResponse::proactiveInsights))
            .setter(setter(Builder::proactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProactiveInsightSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProactiveInsightSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReactiveInsightSummary>> REACTIVE_INSIGHTS_FIELD = SdkField
            .<List<ReactiveInsightSummary>> builder(MarshallingType.LIST)
            .memberName("ReactiveInsights")
            .getter(getter(ListInsightsResponse::reactiveInsights))
            .setter(setter(Builder::reactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReactiveInsightSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReactiveInsightSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInsightsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHTS_FIELD,
            REACTIVE_INSIGHTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProactiveInsightSummary> proactiveInsights;

    private final List<ReactiveInsightSummary> reactiveInsights;

    private final String nextToken;

    private ListInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsights = builder.proactiveInsights;
        this.reactiveInsights = builder.reactiveInsights;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProactiveInsights property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProactiveInsights() {
        return proactiveInsights != null && !(proactiveInsights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of proactive insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProactiveInsights} method.
     * </p>
     * 
     * @return The returned list of proactive insights.
     */
    public final List<ProactiveInsightSummary> proactiveInsights() {
        return proactiveInsights;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReactiveInsights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReactiveInsights() {
        return reactiveInsights != null && !(reactiveInsights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of reactive insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReactiveInsights} method.
     * </p>
     * 
     * @return The returned list of reactive insights.
     */
    public final List<ReactiveInsightSummary> reactiveInsights() {
        return reactiveInsights;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProactiveInsights() ? proactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReactiveInsights() ? reactiveInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsResponse)) {
            return false;
        }
        ListInsightsResponse other = (ListInsightsResponse) obj;
        return hasProactiveInsights() == other.hasProactiveInsights()
                && Objects.equals(proactiveInsights(), other.proactiveInsights())
                && hasReactiveInsights() == other.hasReactiveInsights()
                && Objects.equals(reactiveInsights(), other.reactiveInsights()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsResponse")
                .add("ProactiveInsights", hasProactiveInsights() ? proactiveInsights() : null)
                .add("ReactiveInsights", hasReactiveInsights() ? reactiveInsights() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProactiveInsights":
            return Optional.ofNullable(clazz.cast(proactiveInsights()));
        case "ReactiveInsights":
            return Optional.ofNullable(clazz.cast(reactiveInsights()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProactiveInsights", PROACTIVE_INSIGHTS_FIELD);
        map.put("ReactiveInsights", REACTIVE_INSIGHTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsResponse, T> g) {
        return obj -> g.apply((ListInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInsightsResponse> {
        /**
         * <p>
         * The returned list of proactive insights.
         * </p>
         * 
         * @param proactiveInsights
         *        The returned list of proactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(Collection<ProactiveInsightSummary> proactiveInsights);

        /**
         * <p>
         * The returned list of proactive insights.
         * </p>
         * 
         * @param proactiveInsights
         *        The returned list of proactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(ProactiveInsightSummary... proactiveInsights);

        /**
         * <p>
         * The returned list of proactive insights.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #proactiveInsights(List<ProactiveInsightSummary>)}.
         * 
         * @param proactiveInsights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveInsights(java.util.Collection<ProactiveInsightSummary>)
         */
        Builder proactiveInsights(Consumer<ProactiveInsightSummary.Builder>... proactiveInsights);

        /**
         * <p>
         * The returned list of reactive insights.
         * </p>
         * 
         * @param reactiveInsights
         *        The returned list of reactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(Collection<ReactiveInsightSummary> reactiveInsights);

        /**
         * <p>
         * The returned list of reactive insights.
         * </p>
         * 
         * @param reactiveInsights
         *        The returned list of reactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(ReactiveInsightSummary... reactiveInsights);

        /**
         * <p>
         * The returned list of reactive insights.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #reactiveInsights(List<ReactiveInsightSummary>)}.
         * 
         * @param reactiveInsights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reactiveInsights(java.util.Collection<ReactiveInsightSummary>)
         */
        Builder reactiveInsights(Consumer<ReactiveInsightSummary.Builder>... reactiveInsights);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private List<ProactiveInsightSummary> proactiveInsights = DefaultSdkAutoConstructList.getInstance();

        private List<ReactiveInsightSummary> reactiveInsights = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsResponse model) {
            super(model);
            proactiveInsights(model.proactiveInsights);
            reactiveInsights(model.reactiveInsights);
            nextToken(model.nextToken);
        }

        public final List<ProactiveInsightSummary.Builder> getProactiveInsights() {
            List<ProactiveInsightSummary.Builder> result = ProactiveInsightsCopier.copyToBuilder(this.proactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProactiveInsights(Collection<ProactiveInsightSummary.BuilderImpl> proactiveInsights) {
            this.proactiveInsights = ProactiveInsightsCopier.copyFromBuilder(proactiveInsights);
        }

        @Override
        public final Builder proactiveInsights(Collection<ProactiveInsightSummary> proactiveInsights) {
            this.proactiveInsights = ProactiveInsightsCopier.copy(proactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(ProactiveInsightSummary... proactiveInsights) {
            proactiveInsights(Arrays.asList(proactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proactiveInsights(Consumer<ProactiveInsightSummary.Builder>... proactiveInsights) {
            proactiveInsights(Stream.of(proactiveInsights).map(c -> ProactiveInsightSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReactiveInsightSummary.Builder> getReactiveInsights() {
            List<ReactiveInsightSummary.Builder> result = ReactiveInsightsCopier.copyToBuilder(this.reactiveInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReactiveInsights(Collection<ReactiveInsightSummary.BuilderImpl> reactiveInsights) {
            this.reactiveInsights = ReactiveInsightsCopier.copyFromBuilder(reactiveInsights);
        }

        @Override
        public final Builder reactiveInsights(Collection<ReactiveInsightSummary> reactiveInsights) {
            this.reactiveInsights = ReactiveInsightsCopier.copy(reactiveInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(ReactiveInsightSummary... reactiveInsights) {
            reactiveInsights(Arrays.asList(reactiveInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactiveInsights(Consumer<ReactiveInsightSummary.Builder>... reactiveInsights) {
            reactiveInsights(Stream.of(reactiveInsights).map(c -> ReactiveInsightSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInsightsResponse build() {
            return new ListInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
