/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about whether DevOps Guru is configured to encrypt server-side data using KMS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KMSServerSideEncryptionIntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KMSServerSideEncryptionIntegrationConfig.Builder, KMSServerSideEncryptionIntegrationConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(KMSServerSideEncryptionIntegrationConfig::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus").getter(getter(KMSServerSideEncryptionIntegrationConfig::optInStatusAsString))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(KMSServerSideEncryptionIntegrationConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            OPT_IN_STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String optInStatus;

    private final String type;

    private KMSServerSideEncryptionIntegrationConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.optInStatus = builder.optInStatus;
        this.type = builder.type;
    }

    /**
     * <p>
     * Describes the specified KMS key.
     * </p>
     * <p>
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with
     * "alias/". If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias with no key ID),
     * Amazon Web Services KMS associates the alias with an Amazon Web Services managed key and returns its KeyId and
     * Arn in the response. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or
     * alias ARN.
     * </p>
     * <p>
     * For example:
     * </p>
     * <p>
     * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * <p>
     * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     * </p>
     * <p>
     * Alias name: alias/ExampleAlias
     * </p>
     * <p>
     * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
     * </p>
     * 
     * @return Describes the specified KMS key.</p>
     *         <p>
     *         To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix
     *         it with "alias/". If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias
     *         with no key ID), Amazon Web Services KMS associates the alias with an Amazon Web Services managed key and
     *         returns its KeyId and Arn in the response. To specify a KMS key in a different Amazon Web Services
     *         account, you must use the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <p>
     *         Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         <p>
     *         Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     *         </p>
     *         <p>
     *         Alias name: alias/ExampleAlias
     *         </p>
     *         <p>
     *         Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies if DevOps Guru is enabled for KMS integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link OptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Specifies if DevOps Guru is enabled for KMS integration.
     * @see OptInStatus
     */
    public final OptInStatus optInStatus() {
        return OptInStatus.fromValue(optInStatus);
    }

    /**
     * <p>
     * Specifies if DevOps Guru is enabled for KMS integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link OptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Specifies if DevOps Guru is enabled for KMS integration.
     * @see OptInStatus
     */
    public final String optInStatusAsString() {
        return optInStatus;
    }

    /**
     * <p>
     * The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services owned keys
     * are keys that are owned and managed by DevOps Guru.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServerSideEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services
     *         owned keys are keys that are owned and managed by DevOps Guru.
     * @see ServerSideEncryptionType
     */
    public final ServerSideEncryptionType type() {
        return ServerSideEncryptionType.fromValue(type);
    }

    /**
     * <p>
     * The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services owned keys
     * are keys that are owned and managed by DevOps Guru.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServerSideEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services
     *         owned keys are keys that are owned and managed by DevOps Guru.
     * @see ServerSideEncryptionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSServerSideEncryptionIntegrationConfig)) {
            return false;
        }
        KMSServerSideEncryptionIntegrationConfig other = (KMSServerSideEncryptionIntegrationConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(optInStatusAsString(), other.optInStatusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KMSServerSideEncryptionIntegrationConfig").add("KMSKeyId", kmsKeyId())
                .add("OptInStatus", optInStatusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KMSServerSideEncryptionIntegrationConfig, T> g) {
        return obj -> g.apply((KMSServerSideEncryptionIntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KMSServerSideEncryptionIntegrationConfig> {
        /**
         * <p>
         * Describes the specified KMS key.
         * </p>
         * <p>
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it
         * with "alias/". If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias with no
         * key ID), Amazon Web Services KMS associates the alias with an Amazon Web Services managed key and returns its
         * KeyId and Arn in the response. To specify a KMS key in a different Amazon Web Services account, you must use
         * the key ARN or alias ARN.
         * </p>
         * <p>
         * For example:
         * </p>
         * <p>
         * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * <p>
         * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * </p>
         * <p>
         * Alias name: alias/ExampleAlias
         * </p>
         * <p>
         * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
         * </p>
         * 
         * @param kmsKeyId
         *        Describes the specified KMS key.</p>
         *        <p>
         *        To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name,
         *        prefix it with "alias/". If you specify a predefined Amazon Web Services alias (an Amazon Web Services
         *        alias with no key ID), Amazon Web Services KMS associates the alias with an Amazon Web Services
         *        managed key and returns its KeyId and Arn in the response. To specify a KMS key in a different Amazon
         *        Web Services account, you must use the key ARN or alias ARN.
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <p>
         *        Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        <p>
         *        Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         *        </p>
         *        <p>
         *        Alias name: alias/ExampleAlias
         *        </p>
         *        <p>
         *        Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies if DevOps Guru is enabled for KMS integration.
         * </p>
         * 
         * @param optInStatus
         *        Specifies if DevOps Guru is enabled for KMS integration.
         * @see OptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInStatus
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * Specifies if DevOps Guru is enabled for KMS integration.
         * </p>
         * 
         * @param optInStatus
         *        Specifies if DevOps Guru is enabled for KMS integration.
         * @see OptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInStatus
         */
        Builder optInStatus(OptInStatus optInStatus);

        /**
         * <p>
         * The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services owned
         * keys are keys that are owned and managed by DevOps Guru.
         * </p>
         * 
         * @param type
         *        The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services
         *        owned keys are keys that are owned and managed by DevOps Guru.
         * @see ServerSideEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services owned
         * keys are keys that are owned and managed by DevOps Guru.
         * </p>
         * 
         * @param type
         *        The type of KMS key used. Customer managed keys are the KMS keys that you create. Amazon Web Services
         *        owned keys are keys that are owned and managed by DevOps Guru.
         * @see ServerSideEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionType
         */
        Builder type(ServerSideEncryptionType type);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String optInStatus;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSServerSideEncryptionIntegrationConfig model) {
            kmsKeyId(model.kmsKeyId);
            optInStatus(model.optInStatus);
            type(model.type);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(OptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServerSideEncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public KMSServerSideEncryptionIntegrationConfig build() {
            return new KMSServerSideEncryptionIntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
