/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of open reactive and proactive insights that can be used to gauge the health of your
 * system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightHealth implements SdkPojo, Serializable, ToCopyableBuilder<InsightHealth.Builder, InsightHealth> {
    private static final SdkField<Integer> OPEN_PROACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenProactiveInsights").getter(getter(InsightHealth::openProactiveInsights))
            .setter(setter(Builder::openProactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenProactiveInsights").build())
            .build();

    private static final SdkField<Integer> OPEN_REACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenReactiveInsights").getter(getter(InsightHealth::openReactiveInsights))
            .setter(setter(Builder::openReactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenReactiveInsights").build())
            .build();

    private static final SdkField<Long> MEAN_TIME_TO_RECOVER_IN_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MeanTimeToRecoverInMilliseconds")
            .getter(getter(InsightHealth::meanTimeToRecoverInMilliseconds))
            .setter(setter(Builder::meanTimeToRecoverInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeanTimeToRecoverInMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_PROACTIVE_INSIGHTS_FIELD,
            OPEN_REACTIVE_INSIGHTS_FIELD, MEAN_TIME_TO_RECOVER_IN_MILLISECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer openProactiveInsights;

    private final Integer openReactiveInsights;

    private final Long meanTimeToRecoverInMilliseconds;

    private InsightHealth(BuilderImpl builder) {
        this.openProactiveInsights = builder.openProactiveInsights;
        this.openReactiveInsights = builder.openReactiveInsights;
        this.meanTimeToRecoverInMilliseconds = builder.meanTimeToRecoverInMilliseconds;
    }

    /**
     * <p>
     * The number of open proactive insights.
     * </p>
     * 
     * @return The number of open proactive insights.
     */
    public final Integer openProactiveInsights() {
        return openProactiveInsights;
    }

    /**
     * <p>
     * The number of open reactive insights.
     * </p>
     * 
     * @return The number of open reactive insights.
     */
    public final Integer openReactiveInsights() {
        return openReactiveInsights;
    }

    /**
     * <p>
     * The Meant Time to Recover (MTTR) for the insight.
     * </p>
     * 
     * @return The Meant Time to Recover (MTTR) for the insight.
     */
    public final Long meanTimeToRecoverInMilliseconds() {
        return meanTimeToRecoverInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openProactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(openReactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(meanTimeToRecoverInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightHealth)) {
            return false;
        }
        InsightHealth other = (InsightHealth) obj;
        return Objects.equals(openProactiveInsights(), other.openProactiveInsights())
                && Objects.equals(openReactiveInsights(), other.openReactiveInsights())
                && Objects.equals(meanTimeToRecoverInMilliseconds(), other.meanTimeToRecoverInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightHealth").add("OpenProactiveInsights", openProactiveInsights())
                .add("OpenReactiveInsights", openReactiveInsights())
                .add("MeanTimeToRecoverInMilliseconds", meanTimeToRecoverInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenProactiveInsights":
            return Optional.ofNullable(clazz.cast(openProactiveInsights()));
        case "OpenReactiveInsights":
            return Optional.ofNullable(clazz.cast(openReactiveInsights()));
        case "MeanTimeToRecoverInMilliseconds":
            return Optional.ofNullable(clazz.cast(meanTimeToRecoverInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpenProactiveInsights", OPEN_PROACTIVE_INSIGHTS_FIELD);
        map.put("OpenReactiveInsights", OPEN_REACTIVE_INSIGHTS_FIELD);
        map.put("MeanTimeToRecoverInMilliseconds", MEAN_TIME_TO_RECOVER_IN_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightHealth, T> g) {
        return obj -> g.apply((InsightHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightHealth> {
        /**
         * <p>
         * The number of open proactive insights.
         * </p>
         * 
         * @param openProactiveInsights
         *        The number of open proactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openProactiveInsights(Integer openProactiveInsights);

        /**
         * <p>
         * The number of open reactive insights.
         * </p>
         * 
         * @param openReactiveInsights
         *        The number of open reactive insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openReactiveInsights(Integer openReactiveInsights);

        /**
         * <p>
         * The Meant Time to Recover (MTTR) for the insight.
         * </p>
         * 
         * @param meanTimeToRecoverInMilliseconds
         *        The Meant Time to Recover (MTTR) for the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer openProactiveInsights;

        private Integer openReactiveInsights;

        private Long meanTimeToRecoverInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightHealth model) {
            openProactiveInsights(model.openProactiveInsights);
            openReactiveInsights(model.openReactiveInsights);
            meanTimeToRecoverInMilliseconds(model.meanTimeToRecoverInMilliseconds);
        }

        public final Integer getOpenProactiveInsights() {
            return openProactiveInsights;
        }

        public final void setOpenProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
        }

        @Override
        public final Builder openProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
            return this;
        }

        public final Integer getOpenReactiveInsights() {
            return openReactiveInsights;
        }

        public final void setOpenReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
        }

        @Override
        public final Builder openReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
            return this;
        }

        public final Long getMeanTimeToRecoverInMilliseconds() {
            return meanTimeToRecoverInMilliseconds;
        }

        public final void setMeanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds) {
            this.meanTimeToRecoverInMilliseconds = meanTimeToRecoverInMilliseconds;
        }

        @Override
        public final Builder meanTimeToRecoverInMilliseconds(Long meanTimeToRecoverInMilliseconds) {
            this.meanTimeToRecoverInMilliseconds = meanTimeToRecoverInMilliseconds;
            return this;
        }

        @Override
        public InsightHealth build() {
            return new InsightHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
